/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelResolver;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.BootstrapModelCache;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.jboss.logging.Logger;

public class WorkspaceLoader
implements WorkspaceModelResolver {
    private static final Logger log = Logger.getLogger(WorkspaceLoader.class);
    private static final String POM_XML = "pom.xml";
    private final LocalWorkspace workspace = new LocalWorkspace();
    private final Map<Path, Model> rawModelCache = new HashMap<Path, Model>();
    private final Map<Path, LocalProject> projectCache = new HashMap<Path, LocalProject>();
    private final Path currentProjectPom;
    private Path workspaceRootPom;
    private Function<Path, Model> modelProvider;
    private ModelBuilder modelBuilder;
    private ModelResolver modelResolver;
    private ModelCache modelCache;
    private List<String> activeProfileIds;
    private List<String> inactiveProfileIds;
    private List<Profile> profiles;

    static final Model readModel(Path pom) throws BootstrapMavenException {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (NoSuchFileException e) {
            log.warn((Object)("Module(s) under " + pom.getParent() + " will be handled as thirdparty dependencies because " + pom + " does not exist"));
            return null;
        }
        catch (IOException e) {
            throw new BootstrapMavenException("Failed to read " + pom, e);
        }
    }

    static Path locateCurrentProjectPom(Path path, boolean required) throws BootstrapMavenException {
        for (Path p = path; p != null; p = p.getParent()) {
            Path pom = p.resolve(POM_XML);
            if (!Files.exists(pom, new LinkOption[0])) continue;
            return pom;
        }
        if (required) {
            throw new BootstrapMavenException("Failed to locate project pom.xml for " + path);
        }
        return null;
    }

    WorkspaceLoader(BootstrapMavenContext ctx, Path currentProjectPom, Function<Path, Model> modelProvider) throws BootstrapMavenException {
        this.modelProvider = modelProvider;
        if (ctx != null && ctx.isEffectiveModelBuilder()) {
            this.modelBuilder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
            this.modelResolver = BootstrapModelResolver.newInstance(ctx, this.workspace);
            this.modelCache = new BootstrapModelCache(ctx.getRepositorySystemSession());
            this.profiles = ctx.getActiveSettingsProfiles();
            BootstrapMavenOptions cliOptions = ctx.getCliOptions();
            this.activeProfileIds = new ArrayList<String>(this.profiles.size() + cliOptions.getActiveProfileIds().size());
            for (Profile p : this.profiles) {
                this.activeProfileIds.add(p.getId());
            }
            this.activeProfileIds.addAll(cliOptions.getActiveProfileIds());
            this.inactiveProfileIds = cliOptions.getInactiveProfileIds();
        }
        this.workspace.setBootstrapMavenContext(ctx);
        this.currentProjectPom = this.isPom(currentProjectPom) ? currentProjectPom : WorkspaceLoader.locateCurrentProjectPom(currentProjectPom, true);
    }

    private boolean isPom(Path p) {
        if (Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0])) {
            try {
                this.rawModel(p);
                return true;
            }
            catch (BootstrapMavenException bootstrapMavenException) {
                // empty catch block
            }
        }
        return false;
    }

    private LocalProject project(Path pomFile) throws BootstrapMavenException {
        LocalProject project = this.projectCache.get(pomFile.getParent());
        return project == null ? this.loadAndCacheProject(pomFile) : project;
    }

    private LocalProject loadAndCacheProject(Path pomFile) throws BootstrapMavenException {
        LocalProject project;
        Model cachedRawModel = this.rawModelCache.getOrDefault(pomFile.getParent(), this.modelProvider == null ? null : this.modelProvider.apply(pomFile.getParent()));
        if (this.modelBuilder != null) {
            DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
            req.setPomFile(pomFile.toFile());
            req.setModelResolver(this.modelResolver);
            req.setSystemProperties(System.getProperties());
            req.setUserProperties(System.getProperties());
            req.setModelCache(this.modelCache);
            req.setActiveProfileIds(this.activeProfileIds);
            req.setInactiveProfileIds(this.inactiveProfileIds);
            req.setProfiles(this.profiles);
            req.setRawModel(cachedRawModel);
            req.setWorkspaceModelResolver((WorkspaceModelResolver)this);
            try {
                project = new LocalProject(this.modelBuilder.build((ModelBuildingRequest)req), this.workspace);
            }
            catch (Exception e) {
                throw new BootstrapMavenException("Failed to resolve the effective model for " + pomFile, e);
            }
        } else if (cachedRawModel != null) {
            project = new LocalProject(cachedRawModel, this.workspace);
        } else {
            Model model = WorkspaceLoader.readModel(pomFile);
            if (model == null) {
                return null;
            }
            project = new LocalProject(model, this.workspace);
        }
        this.projectCache.put(pomFile.getParent(), project);
        return project;
    }

    private Model rawModel(Path pomFile) throws BootstrapMavenException {
        Model rawModel = this.rawModelCache.getOrDefault(pomFile.getParent(), this.modelProvider == null ? null : this.modelProvider.apply(pomFile.getParent()));
        if (rawModel == null) {
            rawModel = WorkspaceLoader.readModel(pomFile);
        }
        this.rawModelCache.put(pomFile.getParent(), rawModel);
        return rawModel;
    }

    void setWorkspaceRootPom(Path rootPom) {
        this.workspaceRootPom = rootPom;
    }

    private LocalProject loadProject(Path projectPom, String skipModule) throws BootstrapMavenException {
        Model rawModel = this.rawModel(projectPom);
        Path parentPom = this.getParentPom(projectPom, rawModel);
        LocalProject parentProject = parentPom == null || this.rawModelCache.containsKey(parentPom.getParent()) ? null : this.loadProject(parentPom, parentPom.getParent().relativize(projectPom.getParent()).toString());
        LocalProject project = this.project(projectPom);
        if (project == null) {
            return null;
        }
        if (parentProject != null) {
            parentProject.modules.add(project);
        }
        this.loadProjectModules(project, skipModule);
        return project;
    }

    private Path getParentPom(Path projectPom, Model rawModel) {
        Path parentPom = null;
        Path projectDir = projectPom.getParent();
        Parent parent = rawModel.getParent();
        if (parent != null && parent.getRelativePath() != null && !parent.getRelativePath().isEmpty()) {
            parentPom = projectDir.resolve(parent.getRelativePath()).normalize();
            if (Files.isDirectory(parentPom, new LinkOption[0])) {
                parentPom = parentPom.resolve(POM_XML);
            }
        } else {
            Path parentDir = projectDir.getParent();
            if (parentDir != null) {
                parentPom = parentDir.resolve(POM_XML);
            }
        }
        return parentPom != null && Files.exists(parentPom, new LinkOption[0]) ? parentPom : null;
    }

    private LocalProject loadProjectModules(LocalProject project, String skipModule) throws BootstrapMavenException {
        List modules;
        List list = modules = project.getModelBuildingResult() == null ? project.getRawModel().getModules() : project.getModelBuildingResult().getEffectiveModel().getModules();
        if (!modules.isEmpty()) {
            for (String module : modules) {
                LocalProject childProject;
                if (module.equals(skipModule) || (childProject = this.project(project.getDir().resolve(module).resolve(POM_XML))) == null) continue;
                project.modules.add(this.loadProjectModules(childProject, null));
            }
        }
        return project;
    }

    LocalProject load() throws BootstrapMavenException {
        LocalProject currentProject;
        if (this.workspaceRootPom != null) {
            this.loadProject(this.workspaceRootPom, null);
        }
        if ((currentProject = this.projectCache.get(this.currentProjectPom.getParent())) == null) {
            currentProject = this.loadProject(this.currentProjectPom, null);
        }
        if (this.workspace != null) {
            this.workspace.setCurrentProject(currentProject);
        }
        return currentProject;
    }

    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        LocalProject project = this.workspace.getProject(groupId, artifactId);
        return project != null && ModelUtils.getRawVersion(project.getRawModel()).equals(versionConstraint) ? project.getRawModel() : null;
    }

    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) throws UnresolvableModelException {
        LocalProject project = this.workspace.getProject(groupId, artifactId);
        return project != null && project.getVersion().equals(versionConstraint) ? project.getModelBuildingResult().getEffectiveModel() : null;
    }
}

