/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.MappableCollectionFactory;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public interface Mappable {
    public static <T extends Mappable> Collection<Object> asMaps(Collection<T> col, MappableCollectionFactory factory) {
        if (col == null) {
            return null;
        }
        Collection<Object> result = factory.newCollection(col.size());
        for (Mappable c : col) {
            result.add(c.asMap(factory));
        }
        return result;
    }

    public static <T extends Mappable> Collection<Object> iterableAsMaps(Iterable<T> col, MappableCollectionFactory factory) {
        if (col == null) {
            return null;
        }
        Collection<Object> result = factory.newCollection();
        for (Mappable c : col) {
            result.add(c.asMap(factory));
        }
        return result;
    }

    public static Collection<Object> iterableToStringCollection(Iterable<?> col, MappableCollectionFactory factory) {
        if (col == null) {
            return null;
        }
        Collection<Object> result = factory.newCollection();
        for (Object c : col) {
            result.add(c.toString());
        }
        return result;
    }

    public static Collection<Object> toStringCollection(Collection<?> col, MappableCollectionFactory factory) {
        return Mappable.toStringCollection(col, Object::toString, factory);
    }

    public static <T> Collection<Object> toStringCollection(Collection<T> col, Function<T, String> converter, MappableCollectionFactory factory) {
        if (col == null) {
            return null;
        }
        Collection<Object> result = factory.newCollection(col.size());
        for (T c : col) {
            result.add(converter.apply(c));
        }
        return result;
    }

    default public Map<String, Object> asMap() {
        return this.asMap(MappableCollectionFactory.defaultInstance());
    }

    public Map<String, Object> asMap(MappableCollectionFactory var1);
}

