/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.runtime.Startup;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.logging.Logger;

public class StartupBuildSteps {
    static final DotName STARTUP_NAME = DotName.createSimple((String)Startup.class.getName());
    static final MethodDesc ARC_CONTAINER = MethodDesc.of(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    static final MethodDesc ARC_CONTAINER_BEAN = MethodDesc.of(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    static final MethodDesc ARC_CONTAINER_INSTANCE = MethodDesc.of(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    static final MethodDesc INSTANCE_HANDLE_GET = MethodDesc.of(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    static final MethodDesc CLIENT_PROXY_CONTEXTUAL_INSTANCE = MethodDesc.of(ClientProxy.class, (String)"arc_contextualInstance", Object.class, (Class[])new Class[0]);
    static final MethodDesc CONTEXTUAL_CREATE = MethodDesc.of(Contextual.class, (String)"create", Object.class, (Class[])new Class[]{CreationalContext.class});
    static final MethodDesc CONTEXTUAL_DESTROY = MethodDesc.of(Contextual.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class});
    static final ConstructorDesc CREATIONAL_CONTEXT_IMPL_CTOR = ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class});
    private static final Logger LOG = Logger.getLogger(StartupBuildSteps.class);

    @BuildStep
    AutoAddScopeBuildItem addScope(CustomScopeAnnotationsBuildItem customScopes) {
        return AutoAddScopeBuildItem.builder().defaultScope(BuiltinScope.APPLICATION).match(new AutoAddScopeBuildItem.MatchPredicate(){

            @Override
            public boolean test(ClassInfo clazz, Collection<AnnotationInstance> annotations, IndexView index) {
                if (Annotations.contains(annotations, (DotName)STARTUP_NAME)) {
                    return true;
                }
                for (MethodInfo method : clazz.methods()) {
                    if (!method.hasAnnotation(STARTUP_NAME) || method.hasAnnotation(DotNames.PRODUCES)) continue;
                    return true;
                }
                return false;
            }
        }).reason("Found classes containing @Startup annotation.").build();
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo bean) {
                if (bean.isClassBean()) {
                    return ((AnnotationTarget)bean.getTarget().get()).asClass().hasAnnotation(STARTUP_NAME);
                }
                if (bean.isProducerMethod()) {
                    return !Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (DotName)STARTUP_NAME, (Collection)((AnnotationTarget)bean.getTarget().get()).asMethod().annotations()).isEmpty();
                }
                if (bean.isProducerField()) {
                    return ((AnnotationTarget)bean.getTarget().get()).asField().hasAnnotation(STARTUP_NAME);
                }
                return false;
            }
        });
    }

    @BuildStep
    void registerStartupObservers(ObserverRegistrationPhaseBuildItem observerRegistration, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> configurators) {
        AnnotationStore annotationStore = (AnnotationStore)observerRegistration.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : observerRegistration.getContext().beans()) {
            if (bean.isSynthetic()) {
                OptionalInt startupPriority = bean.getStartupPriority();
                if (!startupPriority.isPresent()) continue;
                this.registerStartupObserver(observerRegistration, bean, bean.getIdentifier(), startupPriority.getAsInt(), null);
                continue;
            }
            AnnotationTarget target = (AnnotationTarget)bean.getTarget().get();
            AnnotationInstance startupAnnotation = annotationStore.getAnnotation(target, STARTUP_NAME);
            if (startupAnnotation != null) {
                AnnotationValue priority = startupAnnotation.value();
                this.registerStartupObserver(observerRegistration, bean, bean.getIdentifier(), priority != null ? priority.asInt() : 2500, null);
            }
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            ArrayList<MethodInfo> startupMethods = new ArrayList<MethodInfo>();
            for (MethodInfo method : target.asClass().methods()) {
                if (!annotationStore.hasAnnotation((AnnotationTarget)method, STARTUP_NAME)) continue;
                if (!(method.isSynthetic() || Modifier.isPrivate(method.flags()) || Modifier.isStatic(method.flags()) || method.parametersCount() != 0 || annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES))) {
                    startupMethods.add(method);
                    continue;
                }
                if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) continue;
                LOG.warnf("Ignored an invalid @Startup method declared on %s: %s", (Object)method.declaringClass().name(), (Object)method);
            }
            if (startupMethods.isEmpty()) continue;
            for (MethodInfo method : startupMethods) {
                AnnotationValue priority = annotationStore.getAnnotation((AnnotationTarget)method, STARTUP_NAME).value();
                this.registerStartupObserver(observerRegistration, bean, bean.getIdentifier() + method.toString(), priority != null ? priority.asInt() : 2500, method);
            }
        }
    }

    private void registerStartupObserver(ObserverRegistrationPhaseBuildItem observerRegistration, BeanInfo btBean, String id, int priority, MethodInfo startupMethod) {
        ObserverConfigurator configurator = observerRegistration.getContext().configure().beanClass(btBean.getBeanClass()).observedType(StartupEvent.class);
        configurator.id(id);
        configurator.priority(priority);
        configurator.notify(ng -> {
            BlockCreator b0 = ng.notifyMethod();
            LocalVar arc = b0.localVar("arc", b0.invokeStatic(ARC_CONTAINER));
            LocalVar rtBean = b0.localVar("bean", b0.invokeInterface(ARC_CONTAINER_BEAN, (Expr)arc, (Expr)Const.of((String)btBean.getIdentifier())));
            if (btBean.canBeInactive()) {
                boolean isInjectedInAlwaysActiveBean = false;
                for (InjectionPointInfo ip : observerRegistration.getBeanProcessor().getBeanDeployment().getInjectionPoints()) {
                    if (!btBean.equals((Object)ip.getResolvedBean()) || !ip.getTargetBean().isPresent() || ((BeanInfo)ip.getTargetBean().get()).canBeInactive()) continue;
                    isInjectedInAlwaysActiveBean = true;
                    break;
                }
                if (!isInjectedInAlwaysActiveBean) {
                    Expr isActive = b0.invokeInterface(MethodDesc.of(InjectableBean.class, (String)"isActive", Boolean.TYPE, (Class[])new Class[0]), (Expr)rtBean);
                    b0.ifNot(isActive, BlockCreator::return_);
                }
            }
            if (BuiltinScope.DEPENDENT.is(btBean.getScope())) {
                LocalVar creationalContext = b0.localVar("cc", b0.new_(CREATIONAL_CONTEXT_IMPL_CTOR, (Expr)rtBean));
                instance = b0.localVar("instance", b0.invokeInterface(CONTEXTUAL_CREATE, (Expr)rtBean, (Expr)creationalContext));
                if (startupMethod != null) {
                    b0.try_(arg_0 -> StartupBuildSteps.lambda$registerStartupObserver$2(startupMethod, (LocalVar)instance, rtBean, creationalContext, arg_0));
                }
                b0.invokeInterface(CONTEXTUAL_DESTROY, (Expr)rtBean, instance, (Expr)creationalContext);
            } else {
                Expr instanceHandle = b0.invokeInterface(ARC_CONTAINER_INSTANCE, (Expr)arc, (Expr)rtBean);
                instance = b0.invokeInterface(INSTANCE_HANDLE_GET, instanceHandle);
                if (startupMethod != null) {
                    b0.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)startupMethod), instance);
                } else if (btBean.getScope().isNormal()) {
                    Expr proxy = b0.cast(instance, ClientProxy.class);
                    b0.invokeInterface(CLIENT_PROXY_CONTEXTUAL_INSTANCE, proxy);
                }
            }
            b0.return_();
        });
        configurator.done();
    }

    private static /* synthetic */ void lambda$registerStartupObserver$2(MethodInfo startupMethod, LocalVar instance, LocalVar rtBean, LocalVar creationalContext, TryCreator tc) {
        tc.body(b1 -> b1.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)startupMethod), (Expr)instance));
        tc.catch_(Exception.class, "e", (b1, e) -> {
            b1.invokeInterface(CONTEXTUAL_DESTROY, (Expr)rtBean, (Expr)instance, (Expr)creationalContext);
            b1.throw_(b1.new_(ConstructorDesc.of(RuntimeException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)"Error calling @Startup method"), (Expr)e));
        });
    }
}

