/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.constant.VarHandleConst;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ListIterator;
import java.util.function.BiConsumer;

abstract class CompareAndSet
extends Item {
    private final Item expect;
    private final Item update;
    private final boolean weak;
    private final MemoryOrder mode;
    private final VarHandleConst handle;
    private final MethodTypeDesc opDesc;

    protected CompareAndSet(Item expect, Item update, boolean weak, MemoryOrder mode, VarHandleConst handle, MethodTypeDesc opDesc) {
        super(ConstantDescs.CD_boolean);
        this.expect = expect;
        this.update = update;
        this.weak = weak;
        this.mode = mode;
        this.handle = handle;
        this.opDesc = opDesc;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.update.process(itr, op);
        this.expect.process(itr, op);
        this.forEachCoordinateDependency(itr, op);
        this.handle.process(itr, op);
    }

    protected void forEachCoordinateDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.invokevirtual(ConstantDescs.CD_VarHandle, switch (this.mode) {
            case MemoryOrder.Volatile -> {
                if (this.weak) {
                    yield "weakCompareAndSet";
                }
                yield "compareAndSet";
            }
            case MemoryOrder.Acquire -> "weakCompareAndSetAcquire";
            case MemoryOrder.Release -> "weakCompareAndSetRelease";
            case MemoryOrder.Plain -> "weakCompareAndSetPlain";
            default -> throw Assert.impossibleSwitchCase((Object)((Object)this.mode));
        }, this.opDesc);
        smb.pop();
        smb.pop();
        this.popCoordinates(smb);
        smb.pop();
        smb.push(this.type());
        smb.wroteCode();
    }

    protected void popCoordinates(StackMapBuilder smb) {
    }
}

