/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.TypeKind;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

final class TryFinally
extends Item {
    final BlockCreatorImpl body;
    final BlockCreatorImpl cleanupTemplate;
    final Consumer<BlockCreator> cleanupBuilder;
    Label cleanupAndYield;
    final Map<CleanupKey, Cleanup> cleanups = new LinkedHashMap<CleanupKey, Cleanup>();
    IllegalStateException written = null;

    TryFinally(BlockCreatorImpl body, Consumer<BlockCreator> cleanupBuilder) {
        this.body = body;
        this.cleanupTemplate = new BlockCreatorImpl(body.parent());
        this.cleanupBuilder = cleanupBuilder;
        body.tryFinally = this;
        body.parent().nesting(() -> this.cleanupTemplate.accept(cleanupBuilder));
    }

    BlockCreatorImpl body() {
        return this.body;
    }

    Label cleanupAndYield() {
        Label cleanupAndYield = this.cleanupAndYield;
        if (cleanupAndYield == null) {
            cleanupAndYield = this.cleanupAndYield = this.body.newLabel();
        }
        return cleanupAndYield;
    }

    Label cleanup(CleanupKey key) {
        Cleanup cleanup = this.cleanups.get(key);
        if (cleanup == null) {
            cleanup = new Cleanup(this.body.newLabel(), key);
            this.cleanups.put(key, cleanup);
        }
        return cleanup.label();
    }

    @Override
    public boolean mayFallThrough() {
        return this.body.mayFallThrough() && this.cleanupTemplate.mayFallThrough();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        BlockCreatorImpl copy;
        if (this.written != null) {
            throw this.written;
        }
        this.written = new IllegalStateException();
        boolean bodyFallsThrough = this.body.mayFallThrough();
        Label cleanupAndThrow = cb.newLabel();
        this.body.writeCode(cb, block);
        cb.exceptionCatchAll(this.body.startLabel(), this.body.endLabel(), cleanupAndThrow);
        if (bodyFallsThrough) {
            cb.goto_(this.cleanupAndYield());
        }
        for (Cleanup value : this.cleanups.values()) {
            cb.labelBinding(value.label());
            if (!this.cleanupTemplate.mayFallThrough()) {
                switch (TypeKind.from((TypeDescriptor.OfField)value.type()).slotSize()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        cb.pop();
                        break;
                    }
                    case 2: {
                        cb.pop2();
                    }
                }
                cb.goto_(this.cleanupAndYield());
                continue;
            }
            copy = new BlockCreatorImpl(this.body.parent(), value.type());
            copy.accept((b, val) -> {
                this.cleanupBuilder.accept((BlockCreator)b);
                if (b.active()) {
                    value.action().terminate((BlockCreatorImpl)b, (Expr)val);
                }
            });
            copy.writeCode(cb, block);
        }
        cb.labelBinding(cleanupAndThrow);
        if (!this.cleanupTemplate.mayFallThrough() && this.body.type().equals(ConstantDescs.CD_void)) {
            cb.pop();
            this.cleanupAndYield();
        } else {
            copy = new BlockCreatorImpl(this.body.parent(), ConstantDescs.CD_Throwable);
            copy.accept((b, val) -> {
                this.cleanupBuilder.accept((BlockCreator)b);
                if (b.active()) {
                    b.throw_((Expr)val);
                }
            });
            copy.writeCode(cb, block);
        }
        if (this.cleanupAndYield != null) {
            cb.labelBinding(this.cleanupAndYield);
            copy = new BlockCreatorImpl(this.body.parent(), this.body.type(), this.body.type());
            copy.accept((b, val) -> {
                this.cleanupBuilder.accept((BlockCreator)b);
                if (b.active()) {
                    b.yield((Expr)val);
                }
            });
            copy.writeCode(cb, block);
        }
    }

    record Cleanup(Label label, CleanupKey action) {
        ClassDesc type() {
            return this.action.type();
        }
    }

    static abstract class CleanupKey {
        CleanupKey() {
        }

        ClassDesc type() {
            return ConstantDescs.CD_void;
        }

        abstract void terminate(BlockCreatorImpl var1, Expr var2);
    }
}

