/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.Box;
import io.quarkus.gizmo2.impl.CheckCast;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Preconditions;
import io.quarkus.gizmo2.impl.PrimitiveCast;
import io.quarkus.gizmo2.impl.Unbox;
import io.quarkus.gizmo2.impl.Util;
import java.io.Serializable;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class Conversions {
    private static final String DS_boolean = "Z";
    private static final String DS_byte = "B";
    private static final String DS_char = "C";
    private static final String DS_double = "D";
    private static final String DS_float = "F";
    private static final String DS_int = "I";
    private static final String DS_long = "J";
    private static final String DS_short = "S";
    private static final String DS_void = "V";
    private static final String DS_Object = Object.class.descriptorString().intern();
    private static final String DS_Boolean = Boolean.class.descriptorString().intern();
    private static final String DS_Byte = Byte.class.descriptorString().intern();
    private static final String DS_Character = Character.class.descriptorString().intern();
    private static final String DS_Double = Double.class.descriptorString().intern();
    private static final String DS_Float = Float.class.descriptorString().intern();
    private static final String DS_Integer = Integer.class.descriptorString().intern();
    private static final String DS_Long = Long.class.descriptorString().intern();
    private static final String DS_Short = Short.class.descriptorString().intern();
    private static final String DS_Void = Void.class.descriptorString().intern();
    private static final String DS_Comparable = Comparable.class.descriptorString().intern();
    private static final String DS_Constable = Constable.class.descriptorString().intern();
    private static final String DS_Number = Number.class.descriptorString().intern();
    private static final String DS_Serializable = Serializable.class.descriptorString().intern();
    private static final String DS_ConstantDesc = ConstantDesc.class.descriptorString().intern();
    private static final Map<String, ClassDesc> boxTypes = Map.of("Z", ConstantDescs.CD_Boolean, "B", ConstantDescs.CD_Byte, "C", ConstantDescs.CD_Character, "S", ConstantDescs.CD_Short, "I", ConstantDescs.CD_Integer, "J", ConstantDescs.CD_Long, "F", ConstantDescs.CD_Float, "D", ConstantDescs.CD_Double, "V", ConstantDescs.CD_Void);
    private static final Map<String, Set<String>> additionalBoxTypes = Map.of("Z", Set.of(DS_Object, DS_Comparable, DS_Constable, DS_Serializable), "B", Set.of(DS_Object, DS_Number, DS_Comparable, DS_Constable, DS_Serializable), "C", Set.of(DS_Object, DS_Comparable, DS_Constable, DS_Serializable), "S", Set.of(DS_Object, DS_Number, DS_Comparable, DS_Constable, DS_Serializable), "I", Set.of(DS_Object, DS_Number, DS_Comparable, DS_Constable, DS_ConstantDesc, DS_Serializable), "J", Set.of(DS_Object, DS_Number, DS_Comparable, DS_Constable, DS_ConstantDesc, DS_Serializable), "F", Set.of(DS_Object, DS_Number, DS_Comparable, DS_Constable, DS_ConstantDesc, DS_Serializable), "D", Set.of(DS_Object, DS_Number, DS_Comparable, DS_Constable, DS_ConstantDesc, DS_Serializable), "V", Set.of(DS_Object));
    private static final Map<String, ClassDesc> unboxTypes = Map.of(DS_Boolean, ConstantDescs.CD_boolean, DS_Byte, ConstantDescs.CD_byte, DS_Character, ConstantDescs.CD_char, DS_Short, ConstantDescs.CD_short, DS_Integer, ConstantDescs.CD_int, DS_Long, ConstantDescs.CD_long, DS_Float, ConstantDescs.CD_float, DS_Double, ConstantDescs.CD_double, DS_Void, ConstantDescs.CD_void);
    private static final Map<String, Set<String>> primitiveWideningConversions = Map.of("Z", Set.of(), "B", Set.of("S", "I", "J", "F", "D"), "C", Set.of("I", "J", "F", "D"), "S", Set.of("I", "J", "F", "D"), "I", Set.of("J", "F", "D"), "J", Set.of("F", "D"), "F", Set.of("D"), "D", Set.of(), "V", Set.of());

    Conversions() {
    }

    static boolean isPrimitive(ClassDesc type) {
        return boxTypes.containsKey(type.descriptorString());
    }

    static boolean isPrimitiveWrapper(ClassDesc type) {
        return unboxTypes.containsKey(type.descriptorString());
    }

    static Optional<ClassDesc> boxingConversion(ClassDesc type) {
        return Optional.ofNullable(boxTypes.get(type.descriptorString()));
    }

    static Optional<ClassDesc> unboxingConversion(ClassDesc type) {
        return Optional.ofNullable(unboxTypes.get(type.descriptorString()));
    }

    static Item convert(Expr expr, ClassDesc toType) {
        Item item = (Item)expr;
        ClassDesc fromType = item.type();
        String toDesc = toType.descriptorString();
        String fromDesc = fromType.descriptorString();
        if (fromDesc.equals(toDesc)) {
            return item;
        }
        if (Util.equals(toType, boxTypes.get(fromDesc))) {
            return new Box(item);
        }
        if (fromType.isPrimitive() && additionalBoxTypes.get(fromDesc).contains(toDesc)) {
            return new Box(item, toType);
        }
        if (fromType.isPrimitive() && unboxTypes.containsKey(toDesc)) {
            ClassDesc widerType = unboxTypes.get(toDesc);
            if (primitiveWideningConversions.get(fromDesc).contains(widerType.descriptorString())) {
                return new Box(new PrimitiveCast(item, widerType));
            }
        } else {
            if (Util.equals(toType, unboxTypes.get(fromDesc))) {
                return new Unbox(item);
            }
            if (toType.isPrimitive() && unboxTypes.containsKey(fromDesc) && primitiveWideningConversions.get(unboxTypes.get(fromDesc).descriptorString()).contains(toDesc)) {
                return new PrimitiveCast(new Unbox(item), toType);
            }
            if (fromType.isPrimitive() && toType.isPrimitive() && primitiveWideningConversions.get(fromDesc).contains(toDesc)) {
                return new PrimitiveCast(item, toType);
            }
            if (DS_Object.equals(fromDesc)) {
                if (toType.isPrimitive()) {
                    return new Unbox(new CheckCast(item, boxTypes.get(toDesc), null));
                }
                return new CheckCast(item, toType, null);
            }
        }
        Preconditions.requireSameLoadableTypeKind(fromType, toType);
        return item;
    }

    static Optional<ClassDesc> numericPromotion(ClassDesc a, ClassDesc b) {
        if (a.isClassOrInterface()) {
            a = unboxTypes.getOrDefault(a.descriptorString(), a);
        }
        if (b.isClassOrInterface()) {
            b = unboxTypes.getOrDefault(b.descriptorString(), b);
        }
        if (a.isPrimitive() && b.isPrimitive()) {
            TypeKind aKind = TypeKind.from(a);
            TypeKind bKind = TypeKind.from(b);
            if (aKind == TypeKind.DOUBLE || bKind == TypeKind.DOUBLE) {
                return Optional.of(ConstantDescs.CD_double);
            }
            if (aKind == TypeKind.FLOAT || bKind == TypeKind.FLOAT) {
                return Optional.of(ConstantDescs.CD_float);
            }
            if (aKind == TypeKind.LONG || bKind == TypeKind.LONG) {
                return Optional.of(ConstantDescs.CD_long);
            }
            return Optional.of(ConstantDescs.CD_int);
        }
        return Optional.empty();
    }

    static boolean numericPromotionRequired(If.Kind kind, ClassDesc a, ClassDesc b) {
        if (kind != If.Kind.EQ && kind != If.Kind.NE) {
            return true;
        }
        return a.isPrimitive() && !DS_boolean.equals(a.descriptorString()) || b.isPrimitive() && !DS_boolean.equals(b.descriptorString());
    }
}

