/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InstanceImpl;
import io.quarkus.arc.impl.SyntheticCreationalContextImpl;
import io.quarkus.arc.impl.bcextensions.ParametersImpl;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ConfiguratorBase;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.CustomAlterableContexts;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.InvokerFactory;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ObserverRegistrar;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.StereotypeRegistrar;
import io.quarkus.arc.processor.bcextensions.BuildServicesImpl;
import io.quarkus.arc.processor.bcextensions.ExtensionInvoker;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseDiscovery;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseEnhancement;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseRegistration;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseSynthesis;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseValidation;
import io.quarkus.arc.processor.bcextensions.MetaAnnotationsImpl;
import io.quarkus.arc.processor.bcextensions.SharedErrors;
import io.quarkus.arc.processor.bcextensions.SyntheticBeanBuilderImpl;
import io.quarkus.arc.processor.bcextensions.SyntheticObserverBuilderImpl;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.Parameters;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanCreator;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanDisposer;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticObserver;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;
import org.jboss.jandex.Type;

public class ExtensionsEntryPoint {
    private final ExtensionInvoker invoker;
    private final SharedErrors errors;
    private final Map<DotName, ClassConfig> qualifiers;
    private final Map<DotName, ClassConfig> interceptorBindings;
    private final Map<DotName, ClassConfig> stereotypes;
    private final List<MetaAnnotationsImpl.ContextData> contexts;
    private final List<AnnotationTransformation> preAnnotationTransformations;
    private volatile MutableAnnotationOverlay annotationOverlay;
    private final List<SyntheticBeanBuilderImpl<?>> syntheticBeans;
    private final List<SyntheticObserverBuilderImpl<?>> syntheticObservers;

    public ExtensionsEntryPoint() {
        this(List.of());
    }

    public ExtensionsEntryPoint(List<BuildCompatibleExtension> extensions) {
        this.invoker = new ExtensionInvoker(extensions);
        if (this.invoker.isEmpty()) {
            this.errors = null;
            this.qualifiers = null;
            this.interceptorBindings = null;
            this.stereotypes = null;
            this.contexts = null;
            this.preAnnotationTransformations = null;
            this.syntheticBeans = null;
            this.syntheticObservers = null;
        } else {
            this.errors = new SharedErrors();
            this.qualifiers = new ConcurrentHashMap<DotName, ClassConfig>();
            this.interceptorBindings = new ConcurrentHashMap<DotName, ClassConfig>();
            this.stereotypes = new ConcurrentHashMap<DotName, ClassConfig>();
            this.contexts = Collections.synchronizedList(new ArrayList());
            this.preAnnotationTransformations = Collections.synchronizedList(new ArrayList());
            this.syntheticBeans = Collections.synchronizedList(new ArrayList());
            this.syntheticObservers = Collections.synchronizedList(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDiscovery(IndexView applicationIndex, Set<String> additionalClasses) {
        if (this.invoker.isEmpty()) {
            return;
        }
        MutableAnnotationOverlay overlay = MutableAnnotationOverlay.builder((IndexView)applicationIndex).compatibleMode().runtimeAnnotationsOnly().inheritedAnnotations().build();
        try {
            BuildServicesImpl.init(applicationIndex, overlay);
            IndexView computingApplicationIndex = BeanArchives.buildComputingBeanArchiveIndex(Thread.currentThread().getContextClassLoader(), new ConcurrentHashMap<DotName, Optional<ClassInfo>>(), applicationIndex);
            new ExtensionPhaseDiscovery(this.invoker, computingApplicationIndex, this.errors, additionalClasses, overlay, this.qualifiers, this.interceptorBindings, this.stereotypes, this.contexts).run();
        }
        finally {
            this.preAnnotationTransformations.addAll(overlay.freeze());
            BuildServicesImpl.reset();
        }
    }

    public void registerMetaAnnotations(BeanProcessor.Builder builder, final CustomAlterableContexts customAlterableContexts) {
        if (this.invoker.isEmpty()) {
            return;
        }
        builder.addAnnotationTransformation(new AnnotationTransformation(){

            public void apply(AnnotationTransformation.TransformationContext context) {
                for (AnnotationTransformation preAnnotationTransformation : ExtensionsEntryPoint.this.preAnnotationTransformations) {
                    if (!preAnnotationTransformation.supports(context.declaration().kind())) continue;
                    preAnnotationTransformation.apply(context);
                }
            }
        });
        if (!this.qualifiers.isEmpty()) {
            builder.addQualifierRegistrar(new QualifierRegistrar(){

                @Override
                public Map<DotName, Set<String>> getAdditionalQualifiers() {
                    HashMap<DotName, Set<String>> result = new HashMap<DotName, Set<String>>();
                    for (Map.Entry<DotName, ClassConfig> entry : ExtensionsEntryPoint.this.qualifiers.entrySet()) {
                        DotName annotationName = entry.getKey();
                        ClassConfig config = entry.getValue();
                        Set nonbindingMembers = config.methods().stream().filter(it -> it.info().hasAnnotation(Nonbinding.class)).map(it -> it.info().name()).collect(Collectors.toUnmodifiableSet());
                        result.put(annotationName, nonbindingMembers);
                    }
                    return result;
                }
            });
        }
        if (!this.interceptorBindings.isEmpty()) {
            builder.addInterceptorBindingRegistrar(new InterceptorBindingRegistrar(){

                @Override
                public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                    return ExtensionsEntryPoint.this.interceptorBindings.entrySet().stream().map(entry -> {
                        DotName annotationName = (DotName)entry.getKey();
                        ClassConfig config = (ClassConfig)entry.getValue();
                        Set<String> nonbindingMembers = config.methods().stream().filter(it -> it.info().hasAnnotation(Nonbinding.class)).map(it -> it.info().name()).collect(Collectors.toUnmodifiableSet());
                        return InterceptorBindingRegistrar.InterceptorBinding.of(annotationName, nonbindingMembers);
                    }).toList();
                }
            });
        }
        if (!this.stereotypes.isEmpty()) {
            builder.addStereotypeRegistrar(new StereotypeRegistrar(){

                @Override
                public Set<DotName> getAdditionalStereotypes() {
                    return ExtensionsEntryPoint.this.stereotypes.keySet();
                }
            });
        }
        if (!this.contexts.isEmpty()) {
            for (final MetaAnnotationsImpl.ContextData context : this.contexts) {
                builder.addContextRegistrar(new ContextRegistrar(){

                    @Override
                    public void register(ContextRegistrar.RegistrationContext registrationContext) {
                        Class<? extends Annotation> scopeAnnotation = context.scopeAnnotation;
                        Class<? extends AlterableContext> contextClass = context.contextClass;
                        ContextConfigurator config = registrationContext.configure(scopeAnnotation);
                        if (InjectableContext.class.isAssignableFrom(contextClass)) {
                            config.contextClass(contextClass);
                        } else {
                            CustomAlterableContexts.CustomAlterableContextInfo info = customAlterableContexts.add(contextClass, context.isNormal, scopeAnnotation);
                            config.creator(cg -> cg.method().new_(ConstructorDesc.of((ClassDesc)ClassDesc.of(info.generatedName))));
                        }
                        if (context.isNormal != null) {
                            config.normal(context.isNormal);
                        }
                        config.done();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEnhancement(IndexView beanArchiveIndex, BeanProcessor.Builder builder) {
        if (this.invoker.isEmpty()) {
            return;
        }
        this.annotationOverlay = MutableAnnotationOverlay.builder((IndexView)beanArchiveIndex).compatibleMode().runtimeAnnotationsOnly().inheritedAnnotations().build();
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlay);
        try {
            new ExtensionPhaseEnhancement(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlay).run();
        }
        catch (Throwable throwable) {
            List annotationTransformations = this.annotationOverlay.freeze();
            builder.addAnnotationTransformation(new AnnotationTransformation(){
                final /* synthetic */ List val$annotationTransformations;
                {
                    this.val$annotationTransformations = list;
                }

                public void apply(AnnotationTransformation.TransformationContext context) {
                    for (AnnotationTransformation annotationTransformation : this.val$annotationTransformations) {
                        if (!annotationTransformation.supports(context.declaration().kind())) continue;
                        annotationTransformation.apply(context);
                    }
                }
            });
            BuildServicesImpl.reset();
            throw throwable;
        }
        List annotationTransformations = this.annotationOverlay.freeze();
        builder.addAnnotationTransformation(new /* invalid duplicate definition of identical inner class */);
        BuildServicesImpl.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRegistration(IndexView beanArchiveIndex, Collection<BeanInfo> allBeans, Collection<InterceptorInfo> allInterceptors, Collection<ObserverInfo> allObservers, InvokerFactory invokerFactory) {
        if (this.invoker.isEmpty()) {
            return;
        }
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlay);
        try {
            new ExtensionPhaseRegistration(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlay, allBeans, allInterceptors, allObservers, invokerFactory).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    public void runSynthesis(IndexView beanArchiveIndex) {
        if (this.invoker.isEmpty()) {
            return;
        }
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlay);
        try {
            new ExtensionPhaseSynthesis(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlay, this.syntheticBeans, this.syntheticObservers).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    public void registerSyntheticBeans(BeanRegistrar.RegistrationContext context, Predicate<DotName> isApplicationClass) {
        if (this.invoker.isEmpty()) {
            return;
        }
        Map<DotName, StereotypeInfo> allStereotypes = context.get(BuildExtension.Key.STEREOTYPES);
        for (SyntheticBeanBuilderImpl<?> syntheticBean : this.syntheticBeans) {
            StereotypeInfo[] stereotypes = (StereotypeInfo[])syntheticBean.stereotypes.stream().map(allStereotypes::get).toArray(StereotypeInfo[]::new);
            boolean dependentByStereotype = false;
            for (StereotypeInfo stereotype : Beans.stereotypesWithTransitive(Arrays.asList(stereotypes), allStereotypes)) {
                ScopeInfo defaultScope = stereotype.getDefaultScope();
                if (defaultScope == null || !BuiltinScope.DEPENDENT.is(defaultScope)) continue;
                dependentByStereotype = true;
                break;
            }
            BeanConfigurator bean = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)context.configure(syntheticBean.implementationClass).types(syntheticBean.types.toArray(new Type[0]))).qualifiers(syntheticBean.qualifiers.toArray(new AnnotationInstance[0]))).stereotypes(stereotypes);
            if (syntheticBean.scope != null) {
                bean.scope(syntheticBean.scope);
            }
            if (syntheticBean.name != null) {
                bean.name(syntheticBean.name);
            }
            if (syntheticBean.isAlternative) {
                bean.alternative(true);
            }
            if (syntheticBean.priority != null) {
                bean.priority(syntheticBean.priority);
            }
            this.configureParams(bean, syntheticBean.params);
            boolean isDependent = syntheticBean.scope == null || Dependent.class.equals(syntheticBean.scope) || dependentByStereotype;
            bean.creator(cg -> {
                BlockCreator bc = cg.createMethod();
                Expr synthCC = bc.cast((Expr)cg.syntheticCreationalContext(), SyntheticCreationalContextImpl.class);
                Expr delegateCC = bc.invokeVirtual(MethodDesc.of(SyntheticCreationalContextImpl.class, (String)"getDelegateCreationalContext", CreationalContext.class, (Class[])new Class[0]), synthCC);
                Expr ccImpl = bc.cast(delegateCC, CreationalContextImpl.class);
                LocalVar lookup = bc.localVar("lookup", bc.invokeStatic(MethodDesc.of(InstanceImpl.class, (String)"forSynthesis", Instance.class, (Class[])new Class[]{CreationalContextImpl.class, Boolean.TYPE}), ccImpl, (Expr)Const.of((boolean)isDependent)));
                LocalVar params = bc.localVar("params", bc.new_(ConstructorDesc.of(ParametersImpl.class, (Class[])new Class[]{Map.class}), (Expr)cg.paramsMap()));
                LocalVar creator = bc.localVar("creator", bc.new_(ConstructorDesc.of(syntheticBean.creatorClass, (Class[])new Class[0])));
                Expr instance = bc.invokeInterface(MethodDesc.of(SyntheticBeanCreator.class, (String)"create", Object.class, (Class[])new Class[]{Instance.class, Parameters.class}), (Expr)creator, (Expr)lookup, (Expr)params);
                bc.return_(instance);
            });
            if (syntheticBean.disposerClass != null) {
                bean.destroyer(dg -> {
                    BlockCreator bc = dg.destroyMethod();
                    LocalVar creationalContextImpl = bc.localVar("creationalContextImpl", bc.cast((Expr)dg.creationalContext(), CreationalContextImpl.class));
                    LocalVar lookup = bc.localVar("lookup", bc.invokeStatic(MethodDesc.of(InstanceImpl.class, (String)"forSynthesis", Instance.class, (Class[])new Class[]{CreationalContextImpl.class, Boolean.TYPE}), (Expr)creationalContextImpl, (Expr)Const.of((boolean)false)));
                    LocalVar params = bc.localVar("params", bc.new_(ConstructorDesc.of(ParametersImpl.class, (Class[])new Class[]{Map.class}), (Expr)dg.paramsMap()));
                    LocalVar disposer = bc.localVar("disposer", bc.new_(ConstructorDesc.of(syntheticBean.disposerClass, (Class[])new Class[0])));
                    bc.invokeInterface(MethodDesc.of(SyntheticBeanDisposer.class, (String)"dispose", Void.TYPE, (Class[])new Class[]{Object.class, Instance.class, Parameters.class}), (Expr)disposer, new Expr[]{dg.destroyedInstance(), lookup, params});
                    bc.invokeVirtual(MethodDesc.of(CreationalContextImpl.class, (String)"release", Void.TYPE, (Class[])new Class[0]), (Expr)creationalContextImpl);
                    bc.return_();
                });
            }
            if (isApplicationClass.test(DotName.createSimple(syntheticBean.creatorClass))) {
                bean.forceApplicationClass();
            }
            if (syntheticBean.disposerClass != null && isApplicationClass.test(DotName.createSimple(syntheticBean.disposerClass))) {
                bean.forceApplicationClass();
            }
            bean.done();
        }
    }

    public void registerSyntheticObservers(ObserverRegistrar.RegistrationContext context, Predicate<DotName> isApplicationClass) {
        if (this.invoker.isEmpty()) {
            return;
        }
        for (SyntheticObserverBuilderImpl<?> syntheticObserver : this.syntheticObservers) {
            if (syntheticObserver.isAsync && syntheticObserver.transactionPhase != TransactionPhase.IN_PROGRESS) {
                throw new IllegalStateException("Synthetic observer declared as asynchronous and transactional (event type " + String.valueOf(syntheticObserver.type) + ", \"declared\" by " + String.valueOf(syntheticObserver.declaringClass) + ", notified using " + String.valueOf(syntheticObserver.implementationClass) + ")");
            }
            ObserverConfigurator observer = context.configure().beanClass(syntheticObserver.declaringClass).observedType(syntheticObserver.type).qualifiers(syntheticObserver.qualifiers.toArray(new AnnotationInstance[0])).priority(syntheticObserver.priority).async(syntheticObserver.isAsync).transactionPhase(syntheticObserver.transactionPhase);
            this.configureParams(observer, syntheticObserver.params);
            observer.notify(ng -> {
                BlockCreator bc = ng.notifyMethod();
                Expr instance = bc.new_(syntheticObserver.implementationClass);
                Expr params = bc.new_(ConstructorDesc.of(ParametersImpl.class, (Class[])new Class[]{Map.class}), (Expr)ng.paramsMap());
                bc.invokeInterface(MethodDesc.of(SyntheticObserver.class, (String)"observe", Void.TYPE, (Class[])new Class[]{EventContext.class, Parameters.class}), instance, (Expr)ng.eventContext(), params);
                bc.return_();
            });
            if (isApplicationClass.test(DotName.createSimple(syntheticObserver.implementationClass))) {
                observer.forceApplicationClass();
            }
            observer.done();
        }
    }

    private void configureParams(ConfiguratorBase<?> configurator, Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                configurator.param(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof boolean[]) {
                configurator.param(entry.getKey(), (boolean[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Byte) {
                configurator.param(entry.getKey(), (Byte)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof byte[]) {
                configurator.param(entry.getKey(), (byte[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Short) {
                configurator.param(entry.getKey(), (Short)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof short[]) {
                configurator.param(entry.getKey(), (short[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                configurator.param(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof int[]) {
                configurator.param(entry.getKey(), (int[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Long) {
                configurator.param(entry.getKey(), (Long)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof long[]) {
                configurator.param(entry.getKey(), (long[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Float) {
                configurator.param(entry.getKey(), ((Float)entry.getValue()).floatValue());
                continue;
            }
            if (entry.getValue() instanceof float[]) {
                configurator.param(entry.getKey(), (float[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Double) {
                configurator.param(entry.getKey(), (Double)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof double[]) {
                configurator.param(entry.getKey(), (double[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Character) {
                configurator.param(entry.getKey(), ((Character)entry.getValue()).charValue());
                continue;
            }
            if (entry.getValue() instanceof char[]) {
                configurator.param(entry.getKey(), (char[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String) {
                configurator.param(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                configurator.param(entry.getKey(), (String[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Enum) {
                configurator.param(entry.getKey(), (Enum)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Enum[]) {
                configurator.param(entry.getKey(), (Enum[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Class) {
                configurator.param(entry.getKey(), (Class)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Class[]) {
                configurator.param(entry.getKey(), (Class[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ClassInfo) {
                configurator.param(entry.getKey(), (ClassInfo)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ClassInfo[]) {
                configurator.param(entry.getKey(), (ClassInfo[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof AnnotationInstance) {
                configurator.param(entry.getKey(), (AnnotationInstance)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof AnnotationInstance[]) {
                configurator.param(entry.getKey(), (AnnotationInstance[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof InvokerInfo) {
                configurator.param(entry.getKey(), (InvokerInfo)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof InvokerInfo[]) {
                configurator.param(entry.getKey(), (InvokerInfo[])entry.getValue());
                continue;
            }
            throw new IllegalStateException("Unknown param: " + String.valueOf(entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRegistrationAgain(IndexView beanArchiveIndex, Collection<BeanInfo> allBeans, Collection<ObserverInfo> allObservers, InvokerFactory invokerFactory) {
        if (this.invoker.isEmpty()) {
            return;
        }
        List<BeanInfo> syntheticBeans = allBeans.stream().filter(BeanInfo::isSynthetic).toList();
        List<ObserverInfo> syntheticObservers = allObservers.stream().filter(ObserverInfo::isSynthetic).toList();
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlay);
        try {
            new ExtensionPhaseRegistration(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlay, syntheticBeans, Collections.emptyList(), syntheticObservers, invokerFactory).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runValidation(IndexView beanArchiveIndex, Collection<BeanInfo> allBeans, Collection<ObserverInfo> allObservers) {
        if (this.invoker.isEmpty()) {
            return;
        }
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlay);
        try {
            new ExtensionPhaseValidation(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlay, allBeans, allObservers).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    public void registerValidationErrors(BeanDeploymentValidator.ValidationContext context) {
        if (this.invoker.isEmpty()) {
            return;
        }
        for (Throwable error : this.errors.list) {
            context.addDeploymentProblem(error);
        }
        this.invoker.invalidate();
    }
}

