/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.contextpropagation;

import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;

public class ObservationThreadLocalAccessor
implements ThreadLocalAccessor<Observation> {
    public static final String KEY = "micrometer.observation";
    private static final ObservationRegistry observationRegistry = ObservationRegistry.create();

    public Object key() {
        return KEY;
    }

    public Observation getValue() {
        return observationRegistry.getCurrentObservation();
    }

    public void setValue(Observation value) {
        value.openScope();
    }

    public void reset() {
        Observation.Scope scope = observationRegistry.getCurrentObservationScope();
        if (scope != null) {
            scope.reset();
        }
    }

    public void restore(Observation value) {
        this.reset();
        Observation.Scope enclosingScope = value.getEnclosingScope();
        if (enclosingScope != null) {
            enclosingScope.makeCurrent();
        }
        this.setValue(value);
    }
}

