/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.highcharts.template;

import io.gatling.charts.report.Container$;
import io.gatling.highcharts.template.Template;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000552A!\u0002\u0004\u0001\u001f!AA\u0003\u0001B\u0001B\u0003%Q\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003 \u0001\u0011\u0005\u0003\u0005C\u0003-\u0001\u0011\u0005\u0003E\u0001\rOk6\u0014WM](g%\u0016\fX/Z:ugR+W\u000e\u001d7bi\u0016T!a\u0002\u0005\u0002\u0011Q,W\u000e\u001d7bi\u0016T!!\u0003\u0006\u0002\u0015!Lw\r[2iCJ$8O\u0003\u0002\f\u0019\u00059q-\u0019;mS:<'\"A\u0007\u0002\u0005%|7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\u0019I!a\u0005\u0004\u0003\u0011Q+W\u000e\u001d7bi\u0016\fAC\\;nE\u0016\u0014xJ\u001a*fcV,7\u000f\u001e(b[\u0016\u001c\bC\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"aA%oi\u00061A(\u001b8jiz\"\"!\b\u0010\u0011\u0005E\u0001\u0001\"\u0002\u000b\u0003\u0001\u0004)\u0012A\u00016t+\u0005\t\u0003C\u0001\u0012*\u001d\t\u0019s\u0005\u0005\u0002%/5\tQE\u0003\u0002'\u001d\u00051AH]8pizJ!\u0001K\f\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q]\tA\u0001\u001b;nY\u0002")
public class NumberOfRequestsTemplate
extends Template {
    private final int numberOfRequestNames;

    @Override
    public String js() {
        return new StringBuilder(1577).append("\nfunction numberOfRequestsDataForGroup(group) {\n  var data = {names: [], oks: [], kos: []};\n\n  $.each(group.contents, function(contentName, content) {\n    if (content.type == '").append(Container$.MODULE$.Group()).append("') {\n      var result = numberOfRequestsDataForGroup(content);\n      data.names = data.names.concat(result.names);\n      data.oks = data.oks.concat(result.oks);\n      data.kos = data.kos.concat(result.kos);\n    }\n    else if (content.type == '").append(Container$.MODULE$.Request()).append("') {\n      data.names.push(content.path);\n      data.oks.push(parseInt(content.stats.numberOfRequests.ok));\n      data.kos.push(parseInt(content.stats.numberOfRequests.ko));\n    }\n  });\n\n  return data;\n}\n\nvar numberOfRequestsData = numberOfRequestsDataForGroup(stats);\n\nnew Highcharts.Chart({\n  chart: {\n    renderTo:'container_number_of_requests',\n    polar:true,\n    type:'column',\n    height:330\n  },\n  credits:{\n    enabled:false\n  },\n  title:{\n    text:'<span class=\"chart_title\">Number of requests</span>',\n    useHTML: true\n  },\n  xAxis:{\n    tickmarkPlacement:'on',\n    tickInterval: ").append((int)package$.MODULE$.ceil((double)this.numberOfRequestNames / (double)1000)).append(",\n    categories:numberOfRequestsData.names,\n    labels:{ enabled:false }\n  },\n  yAxis:{\n    min:0\n  },\n  plotOptions:{\n    series:{\n      stacking:'normal',\n      groupPadding:0,\n      pointPlacement:'on',\n      shadow: true\n    }\n  },\n  legend: {\n    \tborderWidth: 0.5,\n      borderRadius: 3,\n      borderColor: 'black',\n      itemStyle: { fontWeight: \"normal\" }\n  },\n  series:[\n    {\n      name:'KO',\n      data:numberOfRequestsData.kos,\n      color:\"#FF0000\"\n    },\n    {\n      name:'OK',\n      data:numberOfRequestsData.oks,\n      color:\"#4572A7\"\n    }\n  ]\n});\n").toString();
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema polar\">\n              <div id=\"container_number_of_requests\"></div>\n            </div>\n";
    }

    public NumberOfRequestsTemplate(int numberOfRequestNames) {
        this.numberOfRequestNames = numberOfRequestNames;
    }
}

