/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.asn1.cmp;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1EncodableVector;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Object;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Primitive;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Sequence;
import io.gatling.recorder.internal.bouncycastle.asn1.DERSequence;
import io.gatling.recorder.internal.bouncycastle.asn1.cmp.CRLSource;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.Time;

public class CRLStatus
extends ASN1Object {
    private final CRLSource source;
    private final Time time;

    private CRLStatus(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 1 || aSN1Sequence.size() == 2) {
            this.source = CRLSource.getInstance(aSN1Sequence.getObjectAt(0));
            this.time = aSN1Sequence.size() == 2 ? Time.getInstance(aSN1Sequence.getObjectAt(1)) : null;
        } else {
            throw new IllegalArgumentException("expected sequence size of 1 or 2, got " + aSN1Sequence.size());
        }
    }

    public CRLStatus(CRLSource cRLSource, Time time) {
        this.source = cRLSource;
        this.time = time;
    }

    public static CRLStatus getInstance(Object object) {
        if (object instanceof CRLStatus) {
            return (CRLStatus)object;
        }
        if (object != null) {
            return new CRLStatus(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CRLSource getSource() {
        return this.source;
    }

    public Time getTime() {
        return this.time;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.source);
        if (this.time != null) {
            aSN1EncodableVector.add(this.time);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

