/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginBackend;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginBackendBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginBackendFluent;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginCSP;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginCSPBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginCSPFluent;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginI18n;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginI18nBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginI18nFluent;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxy;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxyBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxyFluent;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConsolePluginSpecFluent<A extends ConsolePluginSpecFluent<A>>
extends BaseFluent<A> {
    private ConsolePluginBackendBuilder backend;
    private ArrayList<ConsolePluginCSPBuilder> contentSecurityPolicy = new ArrayList();
    private String displayName;
    private ConsolePluginI18nBuilder i18n;
    private ArrayList<ConsolePluginProxyBuilder> proxy = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ConsolePluginSpecFluent() {
    }

    public ConsolePluginSpecFluent(ConsolePluginSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsolePluginSpec instance) {
        ConsolePluginSpec consolePluginSpec = instance = instance != null ? instance : new ConsolePluginSpec();
        if (instance != null) {
            this.withBackend(instance.getBackend());
            this.withContentSecurityPolicy(instance.getContentSecurityPolicy());
            this.withDisplayName(instance.getDisplayName());
            this.withI18n(instance.getI18n());
            this.withProxy(instance.getProxy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConsolePluginBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    public A withBackend(ConsolePluginBackend backend) {
        this._visitables.remove((Object)"backend");
        if (backend != null) {
            this.backend = new ConsolePluginBackendBuilder(backend);
            this._visitables.get((Object)"backend").add(this.backend);
        } else {
            this.backend = null;
            this._visitables.get((Object)"backend").remove((Object)this.backend);
        }
        return (A)((Object)this);
    }

    public boolean hasBackend() {
        return this.backend != null;
    }

    public BackendNested<A> withNewBackend() {
        return new BackendNested(null);
    }

    public BackendNested<A> withNewBackendLike(ConsolePluginBackend item) {
        return new BackendNested(item);
    }

    public BackendNested<A> editBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(null));
    }

    public BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(new ConsolePluginBackendBuilder().build()));
    }

    public BackendNested<A> editOrNewBackendLike(ConsolePluginBackend item) {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(item));
    }

    public A addToContentSecurityPolicy(int index, ConsolePluginCSP item) {
        if (this.contentSecurityPolicy == null) {
            this.contentSecurityPolicy = new ArrayList();
        }
        ConsolePluginCSPBuilder builder = new ConsolePluginCSPBuilder(item);
        if (index < 0 || index >= this.contentSecurityPolicy.size()) {
            this._visitables.get((Object)"contentSecurityPolicy").add(builder);
            this.contentSecurityPolicy.add(builder);
        } else {
            this._visitables.get((Object)"contentSecurityPolicy").add(builder);
            this.contentSecurityPolicy.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContentSecurityPolicy(int index, ConsolePluginCSP item) {
        if (this.contentSecurityPolicy == null) {
            this.contentSecurityPolicy = new ArrayList();
        }
        ConsolePluginCSPBuilder builder = new ConsolePluginCSPBuilder(item);
        if (index < 0 || index >= this.contentSecurityPolicy.size()) {
            this._visitables.get((Object)"contentSecurityPolicy").add(builder);
            this.contentSecurityPolicy.add(builder);
        } else {
            this._visitables.get((Object)"contentSecurityPolicy").add(builder);
            this.contentSecurityPolicy.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContentSecurityPolicy(ConsolePluginCSP ... items) {
        if (this.contentSecurityPolicy == null) {
            this.contentSecurityPolicy = new ArrayList();
        }
        for (ConsolePluginCSP item : items) {
            ConsolePluginCSPBuilder builder = new ConsolePluginCSPBuilder(item);
            this._visitables.get((Object)"contentSecurityPolicy").add(builder);
            this.contentSecurityPolicy.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContentSecurityPolicy(Collection<ConsolePluginCSP> items) {
        if (this.contentSecurityPolicy == null) {
            this.contentSecurityPolicy = new ArrayList();
        }
        for (ConsolePluginCSP item : items) {
            ConsolePluginCSPBuilder builder = new ConsolePluginCSPBuilder(item);
            this._visitables.get((Object)"contentSecurityPolicy").add(builder);
            this.contentSecurityPolicy.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContentSecurityPolicy(ConsolePluginCSP ... items) {
        if (this.contentSecurityPolicy == null) {
            return (A)((Object)this);
        }
        for (ConsolePluginCSP item : items) {
            ConsolePluginCSPBuilder builder = new ConsolePluginCSPBuilder(item);
            this._visitables.get((Object)"contentSecurityPolicy").remove((Object)builder);
            this.contentSecurityPolicy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContentSecurityPolicy(Collection<ConsolePluginCSP> items) {
        if (this.contentSecurityPolicy == null) {
            return (A)((Object)this);
        }
        for (ConsolePluginCSP item : items) {
            ConsolePluginCSPBuilder builder = new ConsolePluginCSPBuilder(item);
            this._visitables.get((Object)"contentSecurityPolicy").remove((Object)builder);
            this.contentSecurityPolicy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContentSecurityPolicy(Predicate<ConsolePluginCSPBuilder> predicate) {
        if (this.contentSecurityPolicy == null) {
            return (A)((Object)this);
        }
        Iterator<ConsolePluginCSPBuilder> each = this.contentSecurityPolicy.iterator();
        List visitables = this._visitables.get((Object)"contentSecurityPolicy");
        while (each.hasNext()) {
            ConsolePluginCSPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ConsolePluginCSP> buildContentSecurityPolicy() {
        return this.contentSecurityPolicy != null ? ConsolePluginSpecFluent.build(this.contentSecurityPolicy) : null;
    }

    public ConsolePluginCSP buildContentSecurityPolicy(int index) {
        return this.contentSecurityPolicy.get(index).build();
    }

    public ConsolePluginCSP buildFirstContentSecurityPolicy() {
        return this.contentSecurityPolicy.get(0).build();
    }

    public ConsolePluginCSP buildLastContentSecurityPolicy() {
        return this.contentSecurityPolicy.get(this.contentSecurityPolicy.size() - 1).build();
    }

    public ConsolePluginCSP buildMatchingContentSecurityPolicy(Predicate<ConsolePluginCSPBuilder> predicate) {
        for (ConsolePluginCSPBuilder item : this.contentSecurityPolicy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContentSecurityPolicy(Predicate<ConsolePluginCSPBuilder> predicate) {
        for (ConsolePluginCSPBuilder item : this.contentSecurityPolicy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContentSecurityPolicy(List<ConsolePluginCSP> contentSecurityPolicy) {
        if (this.contentSecurityPolicy != null) {
            this._visitables.get((Object)"contentSecurityPolicy").clear();
        }
        if (contentSecurityPolicy != null) {
            this.contentSecurityPolicy = new ArrayList();
            for (ConsolePluginCSP item : contentSecurityPolicy) {
                this.addToContentSecurityPolicy(item);
            }
        } else {
            this.contentSecurityPolicy = null;
        }
        return (A)((Object)this);
    }

    public A withContentSecurityPolicy(ConsolePluginCSP ... contentSecurityPolicy) {
        if (this.contentSecurityPolicy != null) {
            this.contentSecurityPolicy.clear();
            this._visitables.remove((Object)"contentSecurityPolicy");
        }
        if (contentSecurityPolicy != null) {
            for (ConsolePluginCSP item : contentSecurityPolicy) {
                this.addToContentSecurityPolicy(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContentSecurityPolicy() {
        return this.contentSecurityPolicy != null && !this.contentSecurityPolicy.isEmpty();
    }

    public ContentSecurityPolicyNested<A> addNewContentSecurityPolicy() {
        return new ContentSecurityPolicyNested(-1, null);
    }

    public ContentSecurityPolicyNested<A> addNewContentSecurityPolicyLike(ConsolePluginCSP item) {
        return new ContentSecurityPolicyNested(-1, item);
    }

    public ContentSecurityPolicyNested<A> setNewContentSecurityPolicyLike(int index, ConsolePluginCSP item) {
        return new ContentSecurityPolicyNested(index, item);
    }

    public ContentSecurityPolicyNested<A> editContentSecurityPolicy(int index) {
        if (this.contentSecurityPolicy.size() <= index) {
            throw new RuntimeException("Can't edit contentSecurityPolicy. Index exceeds size.");
        }
        return this.setNewContentSecurityPolicyLike(index, this.buildContentSecurityPolicy(index));
    }

    public ContentSecurityPolicyNested<A> editFirstContentSecurityPolicy() {
        if (this.contentSecurityPolicy.size() == 0) {
            throw new RuntimeException("Can't edit first contentSecurityPolicy. The list is empty.");
        }
        return this.setNewContentSecurityPolicyLike(0, this.buildContentSecurityPolicy(0));
    }

    public ContentSecurityPolicyNested<A> editLastContentSecurityPolicy() {
        int index = this.contentSecurityPolicy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last contentSecurityPolicy. The list is empty.");
        }
        return this.setNewContentSecurityPolicyLike(index, this.buildContentSecurityPolicy(index));
    }

    public ContentSecurityPolicyNested<A> editMatchingContentSecurityPolicy(Predicate<ConsolePluginCSPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.contentSecurityPolicy.size(); ++i) {
            if (!predicate.test(this.contentSecurityPolicy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching contentSecurityPolicy. No match found.");
        }
        return this.setNewContentSecurityPolicyLike(index, this.buildContentSecurityPolicy(index));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)((Object)this);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public ConsolePluginI18n buildI18n() {
        return this.i18n != null ? this.i18n.build() : null;
    }

    public A withI18n(ConsolePluginI18n i18n) {
        this._visitables.remove((Object)"i18n");
        if (i18n != null) {
            this.i18n = new ConsolePluginI18nBuilder(i18n);
            this._visitables.get((Object)"i18n").add(this.i18n);
        } else {
            this.i18n = null;
            this._visitables.get((Object)"i18n").remove((Object)this.i18n);
        }
        return (A)((Object)this);
    }

    public boolean hasI18n() {
        return this.i18n != null;
    }

    public A withNewI18n(String loadType) {
        return this.withI18n(new ConsolePluginI18n(loadType));
    }

    public I18nNested<A> withNewI18n() {
        return new I18nNested(null);
    }

    public I18nNested<A> withNewI18nLike(ConsolePluginI18n item) {
        return new I18nNested(item);
    }

    public I18nNested<A> editI18n() {
        return this.withNewI18nLike(Optional.ofNullable(this.buildI18n()).orElse(null));
    }

    public I18nNested<A> editOrNewI18n() {
        return this.withNewI18nLike(Optional.ofNullable(this.buildI18n()).orElse(new ConsolePluginI18nBuilder().build()));
    }

    public I18nNested<A> editOrNewI18nLike(ConsolePluginI18n item) {
        return this.withNewI18nLike(Optional.ofNullable(this.buildI18n()).orElse(item));
    }

    public A addToProxy(int index, ConsolePluginProxy item) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
        if (index < 0 || index >= this.proxy.size()) {
            this._visitables.get((Object)"proxy").add(builder);
            this.proxy.add(builder);
        } else {
            this._visitables.get((Object)"proxy").add(builder);
            this.proxy.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProxy(int index, ConsolePluginProxy item) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
        if (index < 0 || index >= this.proxy.size()) {
            this._visitables.get((Object)"proxy").add(builder);
            this.proxy.add(builder);
        } else {
            this._visitables.get((Object)"proxy").add(builder);
            this.proxy.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProxy(ConsolePluginProxy ... items) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get((Object)"proxy").add(builder);
            this.proxy.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProxy(Collection<ConsolePluginProxy> items) {
        if (this.proxy == null) {
            this.proxy = new ArrayList();
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get((Object)"proxy").add(builder);
            this.proxy.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProxy(ConsolePluginProxy ... items) {
        if (this.proxy == null) {
            return (A)((Object)this);
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get((Object)"proxy").remove((Object)builder);
            this.proxy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProxy(Collection<ConsolePluginProxy> items) {
        if (this.proxy == null) {
            return (A)((Object)this);
        }
        for (ConsolePluginProxy item : items) {
            ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
            this._visitables.get((Object)"proxy").remove((Object)builder);
            this.proxy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        if (this.proxy == null) {
            return (A)((Object)this);
        }
        Iterator<ConsolePluginProxyBuilder> each = this.proxy.iterator();
        List visitables = this._visitables.get((Object)"proxy");
        while (each.hasNext()) {
            ConsolePluginProxyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ConsolePluginProxy> buildProxy() {
        return this.proxy != null ? ConsolePluginSpecFluent.build(this.proxy) : null;
    }

    public ConsolePluginProxy buildProxy(int index) {
        return this.proxy.get(index).build();
    }

    public ConsolePluginProxy buildFirstProxy() {
        return this.proxy.get(0).build();
    }

    public ConsolePluginProxy buildLastProxy() {
        return this.proxy.get(this.proxy.size() - 1).build();
    }

    public ConsolePluginProxy buildMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        for (ConsolePluginProxyBuilder item : this.proxy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        for (ConsolePluginProxyBuilder item : this.proxy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProxy(List<ConsolePluginProxy> proxy) {
        if (this.proxy != null) {
            this._visitables.get((Object)"proxy").clear();
        }
        if (proxy != null) {
            this.proxy = new ArrayList();
            for (ConsolePluginProxy item : proxy) {
                this.addToProxy(item);
            }
        } else {
            this.proxy = null;
        }
        return (A)((Object)this);
    }

    public A withProxy(ConsolePluginProxy ... proxy) {
        if (this.proxy != null) {
            this.proxy.clear();
            this._visitables.remove((Object)"proxy");
        }
        if (proxy != null) {
            for (ConsolePluginProxy item : proxy) {
                this.addToProxy(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProxy() {
        return this.proxy != null && !this.proxy.isEmpty();
    }

    public ProxyNested<A> addNewProxy() {
        return new ProxyNested(-1, null);
    }

    public ProxyNested<A> addNewProxyLike(ConsolePluginProxy item) {
        return new ProxyNested(-1, item);
    }

    public ProxyNested<A> setNewProxyLike(int index, ConsolePluginProxy item) {
        return new ProxyNested(index, item);
    }

    public ProxyNested<A> editProxy(int index) {
        if (this.proxy.size() <= index) {
            throw new RuntimeException("Can't edit proxy. Index exceeds size.");
        }
        return this.setNewProxyLike(index, this.buildProxy(index));
    }

    public ProxyNested<A> editFirstProxy() {
        if (this.proxy.size() == 0) {
            throw new RuntimeException("Can't edit first proxy. The list is empty.");
        }
        return this.setNewProxyLike(0, this.buildProxy(0));
    }

    public ProxyNested<A> editLastProxy() {
        int index = this.proxy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last proxy. The list is empty.");
        }
        return this.setNewProxyLike(index, this.buildProxy(index));
    }

    public ProxyNested<A> editMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.proxy.size(); ++i) {
            if (!predicate.test(this.proxy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching proxy. No match found.");
        }
        return this.setNewProxyLike(index, this.buildProxy(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsolePluginSpecFluent that = (ConsolePluginSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.backend, (Object)that.backend)) {
            return false;
        }
        if (!Objects.equals(this.contentSecurityPolicy, that.contentSecurityPolicy)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals((Object)this.i18n, (Object)that.i18n)) {
            return false;
        }
        if (!Objects.equals(this.proxy, that.proxy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backend, this.contentSecurityPolicy, this.displayName, this.i18n, this.proxy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backend != null) {
            sb.append("backend:");
            sb.append(String.valueOf((Object)this.backend) + ",");
        }
        if (this.contentSecurityPolicy != null && !this.contentSecurityPolicy.isEmpty()) {
            sb.append("contentSecurityPolicy:");
            sb.append(String.valueOf(this.contentSecurityPolicy) + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.i18n != null) {
            sb.append("i18n:");
            sb.append(String.valueOf((Object)this.i18n) + ",");
        }
        if (this.proxy != null && !this.proxy.isEmpty()) {
            sb.append("proxy:");
            sb.append(String.valueOf(this.proxy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProxyNested<N>
    extends ConsolePluginProxyFluent<ProxyNested<N>>
    implements Nested<N> {
        ConsolePluginProxyBuilder builder;
        int index;

        ProxyNested(int index, ConsolePluginProxy item) {
            this.index = index;
            this.builder = new ConsolePluginProxyBuilder(this, item);
        }

        public N and() {
            return (N)ConsolePluginSpecFluent.this.setToProxy(this.index, this.builder.build());
        }

        public N endProxy() {
            return this.and();
        }
    }

    public class I18nNested<N>
    extends ConsolePluginI18nFluent<I18nNested<N>>
    implements Nested<N> {
        ConsolePluginI18nBuilder builder;

        I18nNested(ConsolePluginI18n item) {
            this.builder = new ConsolePluginI18nBuilder(this, item);
        }

        public N and() {
            return (N)ConsolePluginSpecFluent.this.withI18n(this.builder.build());
        }

        public N endI18n() {
            return this.and();
        }
    }

    public class ContentSecurityPolicyNested<N>
    extends ConsolePluginCSPFluent<ContentSecurityPolicyNested<N>>
    implements Nested<N> {
        ConsolePluginCSPBuilder builder;
        int index;

        ContentSecurityPolicyNested(int index, ConsolePluginCSP item) {
            this.index = index;
            this.builder = new ConsolePluginCSPBuilder(this, item);
        }

        public N and() {
            return (N)ConsolePluginSpecFluent.this.setToContentSecurityPolicy(this.index, this.builder.build());
        }

        public N endContentSecurityPolicy() {
            return this.and();
        }
    }

    public class BackendNested<N>
    extends ConsolePluginBackendFluent<BackendNested<N>>
    implements Nested<N> {
        ConsolePluginBackendBuilder builder;

        BackendNested(ConsolePluginBackend item) {
            this.builder = new ConsolePluginBackendBuilder(this, item);
        }

        public N and() {
            return (N)ConsolePluginSpecFluent.this.withBackend(this.builder.build());
        }

        public N endBackend() {
            return this.and();
        }
    }
}

