/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.net.URI;

public class Share {
    private static Runnable firefoxFallbackNotification = () -> Notification.show((String)"Web Share API is not supported, but URL copied to clipboard.");

    public static void setFirefoxFallbackNotification(Runnable firefoxFallbackNotification) {
        Share.firefoxFallbackNotification = firefoxFallbackNotification;
    }

    public static PendingJavaScriptResult share(String title, String text, URI url) {
        return Share.share(new ShareData(title, text, url.toString()));
    }

    public static PendingJavaScriptResult share(String title, String text, String url) {
        return Share.share(new ShareData(title, text, url));
    }

    public static PendingJavaScriptResult share(ShareData data) {
        PendingJavaScriptResult pendingJavaScriptResult = UI.getCurrent().getPage().executeJs("    const data = {\n        title: $0,\n        text: $1,\n        url: $2\n    };\n    if (!navigator.share) {\n        // FF is what it is, but it does support cliboard API these days.\n        // Fall back to copying the URL to clipboard in the same way as MacOS/iOS does when sharing\n        // e.g. to email clients\n        return navigator.clipboard.writeText(data.text + \" \" + data.url)\n            .then(() => {\n                console.warn(\"Web Share API is not supported, but URL copied to clipboard.\");\n                return Promise.resolve(\"CLIPBOARD_COPY_SUCCESS\");\n            })\n            .catch(err => {\n                console.error(\"Failed to copy URL to clipboard:\", err);\n                return Promise.reject(\"CLIPBOARD_COPY_FAILED: \" + err);\n            });\n    } else {\n        return navigator.share(data);\n    }\n", new Object[]{data.title, data.text, data.url});
        pendingJavaScriptResult.then((SerializableConsumer & Serializable)json -> {
            String string = json.asText();
            if ("CLIPBOARD_COPY_SUCCESS".equals(string)) {
                firefoxFallbackNotification.run();
                return;
            }
        }, (SerializableConsumer & Serializable)error -> {});
        return pendingJavaScriptResult;
    }

    public record ShareData(String title, String text, String url) {
    }
}

