/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.geometry.FloatLatLng;
import org.apache.lucene.spatial.geometry.LatLng;
import org.apache.lucene.spatial.geometry.shape.LLRect;
import org.apache.lucene.spatial.tier.CartesianShapeFilter;
import org.apache.lucene.spatial.tier.Shape;
import org.apache.lucene.spatial.tier.projections.CartesianTierPlotter;
import org.apache.lucene.spatial.tier.projections.IProjector;
import org.apache.lucene.spatial.tier.projections.SinusoidalProjector;

public class CartesianPolyFilterBuilder {
    public static final double MILES_FLOOR = 1.0;
    private IProjector projector = new SinusoidalProjector();
    private final String tierPrefix;
    private int minTier;
    private int maxTier;

    public CartesianPolyFilterBuilder(String tierPrefix, int minTierIndexed, int maxTierIndexed) {
        this.tierPrefix = tierPrefix;
        this.minTier = minTierIndexed;
        this.maxTier = maxTierIndexed;
    }

    public Shape getBoxShape(double latitude, double longitude, double miles) {
        CartesianTierPlotter ctp;
        int bestFit;
        if (miles < 1.0) {
            miles = 1.0;
        }
        LLRect box1 = LLRect.createBox(new FloatLatLng(latitude, longitude), miles, miles);
        LatLng ll = box1.getLowerLeft();
        LatLng ur = box1.getUpperRight();
        double latY = ur.getLat();
        double latX = ll.getLat();
        double longY = ur.getLng();
        double longX = ll.getLng();
        double longX2 = 0.0;
        if (ur.getLng() < 0.0 && ll.getLng() > 0.0) {
            longX2 = ll.getLng();
            longX = -180.0;
        }
        if (ur.getLng() > 0.0 && ll.getLng() < 0.0) {
            longX2 = ll.getLng();
            longX = 0.0;
        }
        if ((bestFit = (ctp = new CartesianTierPlotter(2, this.projector, this.tierPrefix)).bestFit(miles)) < this.minTier) {
            bestFit = this.minTier;
        } else if (bestFit > this.maxTier) {
            bestFit = this.maxTier;
        }
        ctp = new CartesianTierPlotter(bestFit, this.projector, this.tierPrefix);
        Shape shape = new Shape(ctp.getTierFieldName());
        shape = this.getShapeLoop(shape, ctp, latX, longX, latY, longY);
        if (longX2 != 0.0) {
            if (longX == 0.0) {
                longX = longX2;
                longY = 0.0;
            } else {
                longX = longX2;
                longY = 180.0;
            }
            shape = this.getShapeLoop(shape, ctp, latX, longX, latY, longY);
        }
        return shape;
    }

    public Shape getShapeLoop(Shape shape, CartesianTierPlotter ctp, double latX, double longX, double latY, double longY) {
        double startX;
        double endAt;
        double beginAt = ctp.getTierBoxId(latX, longX);
        if (beginAt > (endAt = ctp.getTierBoxId(latY, longY))) {
            double tmp = beginAt;
            beginAt = endAt;
            endAt = tmp;
        }
        double tierVert = ctp.getTierVerticalPosDivider();
        double startY = beginAt - startX;
        double endX = endAt - endAt % 1.0;
        double endY = endAt - endX;
        int scale = (int)Math.log10(tierVert);
        endY = new BigDecimal(endY).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
        startY = new BigDecimal(startY).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
        double xInc = 1.0 / tierVert;
        xInc = new BigDecimal(xInc).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
        for (startX = beginAt - beginAt % 1.0; startX <= endX; startX += 1.0) {
            double itY = startY;
            while (itY <= endY) {
                double boxId = startX + itY;
                shape.addBox(boxId);
                itY += xInc;
                itY = new BigDecimal(itY).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
            }
        }
        return shape;
    }

    public Filter getBoundingArea(double latitude, double longitude, double miles) {
        Shape shape = this.getBoxShape(latitude, longitude, miles);
        return new CartesianShapeFilter(shape, shape.getTierId());
    }
}

