/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;

public class SearchGroupShardResponseProcessor
implements ShardResponseProcessor {
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        SortSpec ss = rb.getSortSpec();
        Sort groupSort = rb.getGroupingSpec().getGroupSort();
        String[] fields = rb.getGroupingSpec().getFields();
        HashMap commandSearchGroups = new HashMap();
        HashMap tempSearchGroupToShard = new HashMap();
        for (String field : fields) {
            commandSearchGroups.put(field, new ArrayList(shardRequest.responses.size()));
            tempSearchGroupToShard.put(field, new HashMap());
            if (rb.searchGroupToShard.containsKey(field)) continue;
            rb.searchGroupToShard.put(field, new HashMap());
        }
        SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(rb.req.getSearcher());
        try {
            for (ShardResponse srsp : shardRequest.responses) {
                NamedList firstPhaseResult = (NamedList)srsp.getSolrResponse().getResponse().get("firstPhase");
                Object result = serializer.transformToNative(firstPhaseResult, groupSort, (Sort)null, srsp.getShard());
                for (String field : commandSearchGroups.keySet()) {
                    Collection searchGroups = (Collection)result.get(field);
                    if (searchGroups == null) continue;
                    ((List)commandSearchGroups.get(field)).add(searchGroups);
                    for (SearchGroup searchGroup : searchGroups) {
                        ((Map)tempSearchGroupToShard.get(field)).put(searchGroup, srsp.getShard());
                    }
                }
            }
            for (String groupField : commandSearchGroups.keySet()) {
                List topGroups = (List)commandSearchGroups.get(groupField);
                Collection mergedTopGroups = SearchGroup.merge((List)topGroups, (int)ss.getOffset(), (int)ss.getCount(), (Sort)groupSort);
                if (mergedTopGroups == null) continue;
                rb.mergedSearchGroups.put(groupField, mergedTopGroups);
                for (SearchGroup mergedTopGroup : mergedTopGroups) {
                    rb.searchGroupToShard.get(groupField).put((SearchGroup<String>)mergedTopGroup, (String)((Map)tempSearchGroupToShard.get(groupField)).get(mergedTopGroup));
                }
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }
}

