/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.TermAllGroupHeadsCollector;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetDelegateCollector;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandler {
    private final SolrIndexSearcher.QueryCommand queryCommand;
    private final List<Command> commands;
    private final SolrIndexSearcher searcher;
    private final boolean needDocset;
    private final boolean truncateGroups;
    private DocSet docSet;

    private CommandHandler(SolrIndexSearcher.QueryCommand queryCommand, List<Command> commands, SolrIndexSearcher searcher, boolean needDocset, boolean truncateGroups) {
        this.queryCommand = queryCommand;
        this.commands = commands;
        this.searcher = searcher;
        this.needDocset = needDocset;
        this.truncateGroups = truncateGroups;
    }

    public void execute() throws IOException {
        int nrOfCommands = this.commands.size();
        ArrayList<Collector> collectors = new ArrayList<Collector>(nrOfCommands);
        for (Command command : this.commands) {
            collectors.addAll(command.create());
        }
        SolrIndexSearcher.ProcessedFilter pf = this.searcher.getProcessedFilter(this.queryCommand.getFilter(), this.queryCommand.getFilterList());
        Filter luceneFilter = pf.filter;
        Query query = QueryUtils.makeQueryable(this.queryCommand.getQuery());
        if (this.truncateGroups && nrOfCommands > 0) {
            this.docSet = this.computeGroupedDocSet(query, luceneFilter, collectors);
        } else if (this.needDocset) {
            this.docSet = this.computeDocSet(query, luceneFilter, collectors);
        } else {
            this.searcher.search(query, luceneFilter, MultiCollector.wrap((Collector[])collectors.toArray(new Collector[nrOfCommands])));
        }
    }

    private DocSet computeGroupedDocSet(Query query, Filter luceneFilter, List<Collector> collectors) throws IOException {
        Command firstCommand = this.commands.get(0);
        AbstractAllGroupHeadsCollector termAllGroupHeadsCollector = TermAllGroupHeadsCollector.create((String)firstCommand.getKey(), (Sort)firstCommand.getSortWithinGroup());
        if (collectors.isEmpty()) {
            this.searcher.search(query, luceneFilter, (Collector)termAllGroupHeadsCollector);
        } else {
            collectors.add((Collector)termAllGroupHeadsCollector);
            this.searcher.search(query, luceneFilter, MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()])));
        }
        int maxDoc = this.searcher.maxDoc();
        long[] bits = termAllGroupHeadsCollector.retrieveGroupHeads(maxDoc).getBits();
        return new BitDocSet(new OpenBitSet(bits, bits.length));
    }

    private DocSet computeDocSet(Query query, Filter luceneFilter, List<Collector> collectors) throws IOException {
        DocSetCollector docSetCollector;
        int maxDoc = this.searcher.maxDoc();
        if (collectors.isEmpty()) {
            docSetCollector = new DocSetCollector(maxDoc >> 6, maxDoc);
        } else {
            Collector wrappedCollectors = MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()]));
            docSetCollector = new DocSetDelegateCollector(maxDoc >> 6, maxDoc, wrappedCollectors);
        }
        this.searcher.search(query, luceneFilter, docSetCollector);
        return docSetCollector.getDocSet();
    }

    public NamedList processResult(SolrIndexSearcher.QueryResult queryResult, ShardResultTransformer transformer) throws IOException {
        if (this.docSet != null) {
            queryResult.setDocSet(this.docSet);
        }
        return transformer.transform(this.commands);
    }

    public static class Builder {
        private SolrIndexSearcher.QueryCommand queryCommand;
        private List<Command> commands = new ArrayList<Command>();
        private SolrIndexSearcher searcher;
        private boolean needDocSet = false;
        private boolean truncateGroups = false;

        public Builder setQueryCommand(SolrIndexSearcher.QueryCommand queryCommand) {
            this.queryCommand = queryCommand;
            this.needDocSet = (queryCommand.getFlags() & 0x40000000) != 0;
            return this;
        }

        public Builder addCommandField(Command commandField) {
            this.commands.add(commandField);
            return this;
        }

        public Builder setSearcher(SolrIndexSearcher searcher) {
            this.searcher = searcher;
            return this;
        }

        public Builder setNeedDocSet(boolean needDocSet) {
            this.needDocSet = needDocSet;
            return this;
        }

        public Builder setTruncateGroups(boolean truncateGroups) {
            this.truncateGroups = truncateGroups;
            return this;
        }

        public CommandHandler build() {
            if (this.queryCommand == null || this.searcher == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new CommandHandler(this.queryCommand, this.commands, this.searcher, this.needDocSet, this.truncateGroups);
        }
    }
}

