/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import java.util.ArrayList;
import java.util.List;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final IsSingleCharMatcherVisitor isSingleCharMatcherVisitor = new IsSingleCharMatcherVisitor();
    private final int errorIndex;
    private final MatchHandler inner;
    private final List<MatcherPath> failedMatchers = new ArrayList<MatcherPath>();
    private boolean seeking;

    public ErrorReportingParseRunner(Rule rule, int errorIndex) {
        this(rule, errorIndex, null);
    }

    public ErrorReportingParseRunner(Rule rule, int errorIndex, MatchHandler inner) {
        super(rule);
        this.errorIndex = errorIndex;
        this.inner = inner;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        this.failedMatchers.clear();
        this.seeking = this.errorIndex > 0;
        MatcherContext rootContext = this.createRootContext(inputBuffer, this, false);
        boolean matched = this.match(rootContext);
        if (!matched) {
            this.getParseErrors().add(new InvalidInputError(inputBuffer, this.errorIndex, this.failedMatchers, null));
        }
        return this.createParsingResult(matched, rootContext);
    }

    @Override
    public boolean match(MatcherContext<?> context) {
        boolean matched;
        boolean bl = matched = this.inner == null && context.getMatcher().match(context) || this.inner != null && this.inner.match(context);
        if (context.getCurrentIndex() == this.errorIndex) {
            if (matched && this.seeking) {
                this.seeking = false;
            }
            if (!matched && !this.seeking && context.getMatcher().accept(this.isSingleCharMatcherVisitor).booleanValue()) {
                this.failedMatchers.add(context.getPath());
            }
        }
        return matched;
    }
}

