/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.Collection;
import java.util.List;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.StringUtils;
import org.parboiled.support.LabelPrefixPredicate;
import org.parboiled.support.NodeFormatter;
import org.parboiled.support.ParsingResult;
import org.parboiled.trees.GraphUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseTreeUtils {
    private ParseTreeUtils() {
    }

    public static <V> Node<V> findNodeByPath(Node<V> parent, String path) {
        Preconditions.checkArgNotNull(path, "path");
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.findNodeByPath(parent.getChildren(), path) : null;
    }

    public static <V> Node<V> findNodeByPath(List<Node<V>> parents, String path) {
        Preconditions.checkArgNotNull(path, "path");
        if (parents != null && !parents.isEmpty()) {
            int separatorIndex = path.indexOf(47);
            String prefix = separatorIndex != -1 ? path.substring(0, separatorIndex) : path;
            int start = 0;
            int step = 1;
            if (prefix.startsWith("last:")) {
                prefix = prefix.substring(5);
                start = parents.size() - 1;
                step = -1;
            }
            for (int i = start; 0 <= i && i < parents.size(); i += step) {
                Node<V> child = parents.get(i);
                if (!StringUtils.startsWith(child.getLabel(), prefix)) continue;
                return separatorIndex == -1 ? child : ParseTreeUtils.findNodeByPath(child, path.substring(separatorIndex + 1));
            }
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(Node<V> parent, String path, C collection) {
        Preconditions.checkArgNotNull(path, "path");
        Preconditions.checkArgNotNull(collection, "collection");
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.collectNodesByPath(parent.getChildren(), path, collection) : collection;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodesByPath(List<Node<V>> parents, String path, C collection) {
        Preconditions.checkArgNotNull(path, "path");
        Preconditions.checkArgNotNull(collection, "collection");
        if (parents != null && !parents.isEmpty()) {
            int separatorIndex = path.indexOf(47);
            String prefix = separatorIndex != -1 ? path.substring(0, separatorIndex) : path;
            for (Node<V> child : parents) {
                if (!StringUtils.startsWith(child.getLabel(), prefix)) continue;
                if (separatorIndex == -1) {
                    collection.add(child);
                    continue;
                }
                ParseTreeUtils.collectNodesByPath(child, path.substring(separatorIndex + 1), collection);
            }
        }
        return collection;
    }

    public static <V> Node<V> findNode(Node<V> parent, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (parent != null) {
            Node<V> found;
            if (predicate.apply(parent)) {
                return parent;
            }
            if (GraphUtils.hasChildren(parent) && (found = ParseTreeUtils.findNode(parent.getChildren(), predicate)) != null) {
                return found;
            }
        }
        return null;
    }

    public static <V> Node<V> findNode(List<Node<V>> parents, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (parents != null && !parents.isEmpty()) {
            for (Node<V> child : parents) {
                Node<V> found = ParseTreeUtils.findNode(child, predicate);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static <V> Node<V> findNodeByLabel(Node<V> parent, String labelPrefix) {
        return ParseTreeUtils.findNode(parent, new LabelPrefixPredicate(labelPrefix));
    }

    public static <V> Node<V> findNodeByLabel(List<Node<V>> parents, String labelPrefix) {
        return ParseTreeUtils.findNode(parents, new LabelPrefixPredicate(labelPrefix));
    }

    public static <V> Node<V> findLastNode(Node<V> parent, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (parent != null) {
            Node<V> found;
            if (predicate.apply(parent)) {
                return parent;
            }
            if (GraphUtils.hasChildren(parent) && (found = ParseTreeUtils.findLastNode(parent.getChildren(), predicate)) != null) {
                return found;
            }
        }
        return null;
    }

    public static <V> Node<V> findLastNode(List<Node<V>> parents, Predicate<Node<V>> predicate) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        if (parents != null && !parents.isEmpty()) {
            int parentsSize = parents.size();
            for (int i = parentsSize - 1; i >= 0; --i) {
                Node<V> found = ParseTreeUtils.findLastNode(parents.get(i), predicate);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static <V, C extends Collection<Node<V>>> C collectNodes(Node<V> parent, Predicate<Node<V>> predicate, C collection) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        Preconditions.checkArgNotNull(collection, "collection");
        return parent != null && GraphUtils.hasChildren(parent) ? ParseTreeUtils.collectNodes(parent.getChildren(), predicate, collection) : collection;
    }

    public static String getNodeText(Node<?> node, InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(node, "node");
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        if (node.hasError()) {
            StringBuilder sb = new StringBuilder();
            block6: for (int i = node.getStartIndex(); i < node.getEndIndex(); ++i) {
                char c = inputBuffer.charAt(i);
                switch (c) {
                    case '\ufdea': {
                        ++i;
                        continue block6;
                    }
                    case '\ufdeb': 
                    case '\uffff': {
                        continue block6;
                    }
                    case '\ufded': {
                        ++i;
                        while (inputBuffer.charAt(i) != '\ufdee') {
                            ++i;
                        }
                        continue block6;
                    }
                    case '\ufdec': 
                    case '\ufdee': 
                    case '\ufdef': {
                        throw new IllegalStateException();
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
        return inputBuffer.extract(node.getStartIndex(), node.getEndIndex());
    }

    public static <V, C extends Collection<Node<V>>> C collectNodes(List<Node<V>> parents, Predicate<Node<V>> predicate, C collection) {
        Preconditions.checkArgNotNull(predicate, "predicate");
        Preconditions.checkArgNotNull(collection, "collection");
        if (parents != null && !parents.isEmpty()) {
            for (Node<V> child : parents) {
                if (predicate.apply(child)) {
                    collection.add(child);
                }
                ParseTreeUtils.collectNodes(child, predicate, collection);
            }
        }
        return collection;
    }

    public static <V> String printNodeTree(ParsingResult<V> parsingResult) {
        Preconditions.checkArgNotNull(parsingResult, "parsingResult");
        return ParseTreeUtils.printNodeTree(parsingResult, Predicates.<Node<V>>alwaysTrue(), Predicates.<Node<V>>alwaysTrue());
    }

    public static <V> String printNodeTree(ParsingResult<V> parsingResult, Predicate<Node<V>> nodeFilter, Predicate<Node<V>> subTreeFilter) {
        Preconditions.checkArgNotNull(parsingResult, "parsingResult");
        Preconditions.checkArgNotNull(nodeFilter, "nodeFilter");
        Preconditions.checkArgNotNull(subTreeFilter, "subTreeFilter");
        return GraphUtils.printTree(parsingResult.parseTreeRoot, new NodeFormatter(parsingResult.inputBuffer), nodeFilter, subTreeFilter);
    }
}

