/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import org.parboiled.buffers.DefaultInputBuffer;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.IntArrayStack;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.IllegalIndentationException;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

public class IndentDedentInputBuffer
implements InputBuffer {
    private final DefaultInputBuffer origBuffer;
    private final DefaultInputBuffer convBuffer;
    private int[] indexMap;
    private final boolean strict;

    public IndentDedentInputBuffer(char[] input, int tabStop, String lineCommentStart, boolean strict) {
        this.strict = strict;
        Preconditions.checkArgument(tabStop > 0, "tabStop must be > 0");
        Preconditions.checkArgument(lineCommentStart == null || lineCommentStart.indexOf(10) == -1, "lineCommentStart must not contain newlines");
        this.origBuffer = new DefaultInputBuffer(input);
        BufferConverter converter = new BufferConverter(tabStop, lineCommentStart != null ? lineCommentStart.toCharArray() : null);
        this.convBuffer = new DefaultInputBuffer(converter.builder.getChars());
        this.indexMap = converter.builder.getIndexMap();
    }

    public char charAt(int index) {
        return this.convBuffer.charAt(index);
    }

    public boolean test(int index, char[] characters) {
        return this.convBuffer.test(index, characters);
    }

    public String extract(int start, int end) {
        return this.origBuffer.extract(this.map(start), this.map(end));
    }

    public String extract(IndexRange range) {
        return this.origBuffer.extract(this.map(range.start), this.map(range.end));
    }

    public Position getPosition(int index) {
        return this.origBuffer.getPosition(this.map(index));
    }

    public int getOriginalIndex(int index) {
        return this.map(index);
    }

    public String extractLine(int lineNumber) {
        return this.origBuffer.extractLine(lineNumber);
    }

    public int getLineCount() {
        return this.origBuffer.getLineCount();
    }

    private int map(int convIndex) {
        if (convIndex < 0) {
            return this.indexMap[0];
        }
        if (convIndex < this.indexMap.length) {
            return this.indexMap[convIndex];
        }
        if (this.indexMap.length == 0) {
            return 1;
        }
        return this.indexMap[this.indexMap.length - 1] + 1;
    }

    private class BufferConverter {
        public final BufferBuilder builder = new BufferBuilder();
        private final int tabStop;
        private final char[] lineCommentStart;
        private final IntArrayStack previousLevels = new IntArrayStack();
        private int cursor = 0;
        private char currentChar;

        public BufferConverter(int tabStop, char[] lineCommentStart) {
            this.tabStop = tabStop;
            this.lineCommentStart = lineCommentStart;
            this.currentChar = IndentDedentInputBuffer.this.origBuffer.charAt(0);
            this.build();
        }

        private void build() {
            this.previousLevels.push(0);
            int currentLevel = this.skipIndent();
            while (this.currentChar != '\uffff') {
                int commentChars = this.skipLineComment();
                if (this.currentChar != '\n' && this.currentChar != '\uffff') {
                    this.builder.append(this.currentChar);
                    this.advance();
                    continue;
                }
                this.builder.appendNewline(commentChars);
                this.advance();
                int indent = this.skipIndent();
                if (indent > currentLevel) {
                    this.previousLevels.push(currentLevel);
                    currentLevel = indent;
                    this.builder.append('\ufdd0');
                    continue;
                }
                while (indent < currentLevel && indent <= this.previousLevels.peek()) {
                    currentLevel = this.previousLevels.pop();
                    this.builder.append('\ufdd1');
                }
                if (!IndentDedentInputBuffer.this.strict || indent >= currentLevel) continue;
                throw new IllegalIndentationException(IndentDedentInputBuffer.this.origBuffer, IndentDedentInputBuffer.this.origBuffer.getPosition(this.cursor));
            }
            if (this.previousLevels.size() > 1) {
                this.builder.append('\n');
                while (this.previousLevels.size() > 1) {
                    this.previousLevels.pop();
                    this.builder.append('\ufdd1');
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int skipIndent() {
            int indent = 0;
            block6: while (true) {
                switch (this.currentChar) {
                    case ' ': {
                        ++indent;
                        this.advance();
                        continue block6;
                    }
                    case '\t': {
                        indent = (indent / this.tabStop + 1) * this.tabStop;
                        this.advance();
                        continue block6;
                    }
                    case '\n': {
                        indent = 0;
                        this.advance();
                        continue block6;
                    }
                    case '\uffff': {
                        return 0;
                    }
                    default: {
                        if (this.skipLineComment() == 0) return indent;
                        continue block6;
                    }
                }
                break;
            }
        }

        private void advance() {
            this.currentChar = IndentDedentInputBuffer.this.origBuffer.charAt(++this.cursor);
        }

        private int skipLineComment() {
            if (this.lineCommentStart != null && IndentDedentInputBuffer.this.origBuffer.test(this.cursor, this.lineCommentStart)) {
                int start = this.cursor;
                while (this.currentChar != '\n' && this.currentChar != '\uffff') {
                    this.advance();
                }
                return this.cursor - start;
            }
            return 0;
        }

        private class BufferBuilder {
            private final StringBuilder sb = new StringBuilder();
            private final IntArrayStack indexMap = new IntArrayStack();

            private BufferBuilder() {
            }

            private void append(char c) {
                this.indexMap.push(BufferConverter.this.cursor);
                this.sb.append(c);
            }

            private void appendNewline(int commentChars) {
                this.indexMap.push(BufferConverter.this.cursor - commentChars);
                this.sb.append('\n');
            }

            public char[] getChars() {
                char[] buffer = new char[this.sb.length()];
                this.sb.getChars(0, this.sb.length(), buffer, 0);
                return buffer;
            }

            public int[] getIndexMap() {
                return this.indexMap.toArray();
            }
        }
    }
}

