/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TermFirstPassGroupingCollector;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchGroupsFieldCommand
implements Command<Collection<SearchGroup<String>>> {
    private final SchemaField field;
    private final Sort groupSort;
    private final int topNGroups;
    private TermFirstPassGroupingCollector collector;

    private SearchGroupsFieldCommand(SchemaField field, Sort groupSort, int topNGroups) {
        this.field = field;
        this.groupSort = groupSort;
        this.topNGroups = topNGroups;
    }

    @Override
    public List<Collector> create() throws IOException {
        this.collector = new TermFirstPassGroupingCollector(this.field.getName(), this.groupSort, this.topNGroups);
        return Arrays.asList(this.collector);
    }

    @Override
    public Collection<SearchGroup<String>> result() {
        return this.collector.getTopGroups(0, true);
    }

    @Override
    public Sort getSortWithinGroup() {
        return null;
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    public static class Builder {
        private SchemaField field;
        private Sort groupSort;
        private Integer topNGroups;

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setTopNGroups(int topNGroups) {
            this.topNGroups = topNGroups;
            return this;
        }

        public SearchGroupsFieldCommand build() {
            if (this.field == null || this.groupSort == null || this.topNGroups == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new SearchGroupsFieldCommand(this.field, this.groupSort, this.topNGroups);
        }
    }
}

