/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyCache;

public class WikittyCacheJCS
implements WikittyCache {
    private static Log log = LogFactory.getLog(WikittyCacheJCS.class);
    protected Set<String> priorityExtensions = new HashSet<String>();
    protected GroupCacheAccess priorityCache;
    protected GroupCacheAccess wikittyCache;
    protected GroupCacheAccess extensionCache;

    public WikittyCacheJCS(ApplicationConfig config) {
        try {
            List priorityExtensions = config.getOptionAsList(WikittyConfigOption.WIKITTY_CACHE_PRIORITY_EXTENSIONS.getKey()).getOption();
            this.getPriorityExtensions().addAll(priorityExtensions);
            CompositeCacheManager cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
            cacheMgr.configure(config.getFlatOptions());
            this.priorityCache = new GroupCacheAccess(cacheMgr.getCache("priority"));
            this.wikittyCache = new GroupCacheAccess(cacheMgr.getCache("wikitty"));
            this.extensionCache = new GroupCacheAccess(cacheMgr.getCache("extension"));
        }
        catch (Exception eee) {
            throw new WikittyException("Can't initialise JCS cache", eee);
        }
    }

    public Set<String> getPriorityExtensions() {
        return this.priorityExtensions;
    }

    @Override
    public boolean existsWikitty(String id) {
        boolean result;
        Object o = this.priorityCache.get((Object)id);
        boolean bl = result = o != null;
        if (!result) {
            o = this.wikittyCache.get((Object)id);
            result = o != null;
        }
        return result;
    }

    @Override
    public Wikitty getWikitty(String id) {
        if (id == null) {
            return null;
        }
        Wikitty result = (Wikitty)this.priorityCache.get((Object)id);
        if (result == null) {
            result = (Wikitty)this.wikittyCache.get((Object)id);
        }
        return result;
    }

    @Override
    public void putWikitty(Wikitty e) {
        if (e != null) {
            try {
                if (Collections.disjoint(this.priorityExtensions, e.getExtensionNames())) {
                    this.wikittyCache.put((Object)e.getId(), (Object)e);
                } else {
                    this.priorityCache.put((Object)e.getId(), (Object)e);
                }
            }
            catch (CacheException eee) {
                log.error((Object)String.format("Can't put wikitty %s in cache", e), (Throwable)eee);
            }
        }
    }

    @Override
    public void removeWikitty(String id) {
        try {
            this.priorityCache.remove((Object)id);
            this.wikittyCache.remove((Object)id);
        }
        catch (CacheException eee) {
            log.error((Object)String.format("Can't remove wikitty %s in cache", id), (Throwable)eee);
        }
    }

    @Override
    public void clearWikitty() {
        try {
            this.priorityCache.clear();
            this.wikittyCache.clear();
        }
        catch (CacheException eee) {
            log.error((Object)String.format("Can't clear wikitty cache", new Object[0]), (Throwable)eee);
        }
    }

    @Override
    public boolean existsExtension(String id) {
        Object o = this.extensionCache.get((Object)id);
        boolean result = o != null;
        return result;
    }

    @Override
    public WikittyExtension getExtension(String extId) {
        WikittyExtension result = (WikittyExtension)this.extensionCache.get((Object)extId);
        return result;
    }

    @Override
    public void putExtension(WikittyExtension e) {
        if (e != null) {
            try {
                this.extensionCache.put((Object)e.getId(), (Object)e);
            }
            catch (CacheException eee) {
                log.error((Object)String.format("Can't put extension %s in cache", e), (Throwable)eee);
            }
        }
    }

    @Override
    public void removeExtension(String extId) {
        try {
            this.extensionCache.remove((Object)extId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove extension from JCS cache " + extId));
            }
        }
        catch (CacheException eee) {
            log.error((Object)String.format("Can't remove extensions %s in cache", extId), (Throwable)eee);
        }
    }

    @Override
    public void clearExtension() {
        try {
            this.extensionCache.clear();
        }
        catch (CacheException eee) {
            log.error((Object)String.format("Can't clear extension cache", new Object[0]), (Throwable)eee);
        }
    }
}

