/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.Signature;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private List<String> sigFields;
    private String signatureField;
    private Term signatureTerm;
    private boolean enabled = true;
    private String signatureClass;
    private boolean overwriteDupes;
    private SolrParams params;

    @Override
    public void init(NamedList args) {
        if (args != null) {
            boolean enabled;
            SolrParams params = SolrParams.toSolrParams((NamedList)args);
            this.enabled = enabled = params.getBool("enabled", true);
            this.overwriteDupes = params.getBool("overwriteDupes", true);
            this.signatureField = params.get("signatureField", "signatureField");
            this.signatureTerm = new Term(this.signatureField, "");
            this.signatureClass = params.get("signatureClass", "org.apache.solr.update.processor.Lookup3Signature");
            this.params = params;
            Object fields = args.get("fields");
            List<String> list = this.sigFields = fields == null ? null : StrUtils.splitSmart((String)((String)fields), (String)",", (boolean)true);
            if (this.sigFields != null) {
                Collections.sort(this.sigFields);
            }
        }
    }

    public List<String> getSigFields() {
        return this.sigFields;
    }

    public String getSignatureField() {
        return this.signatureField;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSignatureClass() {
        return this.signatureClass;
    }

    public boolean getOverwriteDupes() {
        return this.overwriteDupes;
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new SignatureUpdateProcessor(req, rsp, this, next);
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    class SignatureUpdateProcessor
    extends UpdateRequestProcessor {
        private final SolrQueryRequest req;

        public SignatureUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, SignatureUpdateProcessorFactory factory, UpdateRequestProcessor next) {
            super(next);
            this.req = req;
        }

        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (SignatureUpdateProcessorFactory.this.enabled) {
                SolrInputDocument doc = cmd.getSolrInputDocument();
                if (SignatureUpdateProcessorFactory.this.sigFields == null || SignatureUpdateProcessorFactory.this.sigFields.size() == 0) {
                    Collection docFields = doc.getFieldNames();
                    SignatureUpdateProcessorFactory.this.sigFields = new ArrayList(docFields.size());
                    SignatureUpdateProcessorFactory.this.sigFields.addAll(docFields);
                    Collections.sort(SignatureUpdateProcessorFactory.this.sigFields);
                }
                Signature sig = (Signature)this.req.getCore().getResourceLoader().newInstance(SignatureUpdateProcessorFactory.this.signatureClass, new String[0]);
                sig.init(SignatureUpdateProcessorFactory.this.params);
                for (String field : SignatureUpdateProcessorFactory.this.sigFields) {
                    SolrInputField f = doc.getField(field);
                    if (f == null) continue;
                    sig.add(field);
                    Object o = f.getValue();
                    if (o instanceof String) {
                        sig.add((String)o);
                        continue;
                    }
                    if (!(o instanceof Collection)) continue;
                    for (Object oo : (Collection)o) {
                        if (!(oo instanceof String)) continue;
                        sig.add((String)oo);
                    }
                }
                byte[] signature = sig.getSignature();
                char[] arr = new char[signature.length << 1];
                for (int i = 0; i < signature.length; ++i) {
                    byte b = signature[i];
                    int idx = i << 1;
                    arr[idx] = StrUtils.HEX_DIGITS[b >> 4 & 0xF];
                    arr[idx + 1] = StrUtils.HEX_DIGITS[b & 0xF];
                }
                String sigString = new String(arr);
                doc.addField(SignatureUpdateProcessorFactory.this.signatureField, (Object)sigString);
                if (SignatureUpdateProcessorFactory.this.overwriteDupes) {
                    cmd.updateTerm = SignatureUpdateProcessorFactory.this.signatureTerm.createTerm(sigString);
                }
            }
            if (this.next != null) {
                this.next.processAdd(cmd);
            }
        }
    }
}

