/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: AlreadyExistingException.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.3/refcomp-services/src/main/java/fr/inra/refcomp/services/AlreadyExistingException.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

/**
 *
 * Exception to be thrown when an entity already exist in database and that only
 * one of those entities is allowed.
 *
 * User: couteau
 * Date: 26 nov. 2010
 */
public class AlreadyExistingException extends RefcompException {

    public AlreadyExistingException() {
        super();
    }

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param message message
     */
    public AlreadyExistingException(String message) {
        super(message);
    }

    /**
     * Constructs a new exception with the specified detail message and cause.
     *
     * @param message
     * @param cause
     */
    public AlreadyExistingException(String message, Throwable cause) {
        super(message, cause);
    }

}
