/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.logging;

import com.arjuna.common.internal.util.logging.LogFactoryInterface;
import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.LogNoi18nImpl;
import com.arjuna.common.internal.util.logging.Logi18nImpl;
import com.arjuna.common.internal.util.logging.commonPropertyManager;
import com.arjuna.common.util.exceptions.LogConfigurationException;
import com.arjuna.common.util.logging.LogNoi18n;
import com.arjuna.common.util.logging.Logi18n;
import java.lang.reflect.Constructor;

public class LogFactory {
    private static LogFactoryInterface m_logFactory = null;
    private static boolean m_isInitialized = false;
    private static long m_debugLevel = 0L;
    private static long m_visLevel = -1L;
    private static long m_facLevel = -1L;

    public static LogNoi18n getLogNoi18n(String name) {
        LogFactory.setupLogSystem();
        LogInterface logInterface = m_logFactory.getLog(name);
        LogNoi18nImpl log = new LogNoi18nImpl(logInterface, m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(String name, String resBundle) {
        LogFactory.setupLogSystem();
        LogInterface logInterface = m_logFactory.getLog(name);
        Logi18nImpl log = new Logi18nImpl(logInterface, resBundle, m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    private static synchronized void setupLogSystem() {
        if (m_isInitialized) {
            return;
        }
        try {
            String logFactory = commonPropertyManager.getLoggingEnvironmentBean().getLoggingFactory();
            String debugLevel = commonPropertyManager.getLoggingEnvironmentBean().getDebugLevel();
            String facLevel = commonPropertyManager.getLoggingEnvironmentBean().getFacilityLevel();
            String visLevel = commonPropertyManager.getLoggingEnvironmentBean().getVisibilityLevel();
            try {
                m_debugLevel = Long.decode(debugLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0L;
            }
            try {
                m_facLevel = Long.decode(facLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0xFFFFFFFL;
            }
            try {
                m_visLevel = Long.decode(visLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0xFFFFFFFL;
            }
            int semicolonIndex = logFactory.indexOf(";");
            m_logFactory = semicolonIndex == -1 ? LogFactory.loadFactory(logFactory, null) : LogFactory.loadFactory(logFactory.substring(0, semicolonIndex), logFactory.substring(semicolonIndex + 1));
        }
        catch (LogConfigurationException e) {
            throw new RuntimeException("An unexpected exception occurred while creating the logger factory: " + e.getMessage(), e);
        }
        m_isInitialized = true;
    }

    private static LogFactoryInterface loadFactory(String classname, String arg) throws LogConfigurationException {
        try {
            LogFactoryInterface logFactoryInterface;
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
            if (arg == null) {
                logFactoryInterface = (LogFactoryInterface)factoryClass.newInstance();
            } else {
                Constructor<?> ctor = factoryClass.getConstructor(String.class);
                logFactoryInterface = (LogFactoryInterface)ctor.newInstance(arg);
            }
            return logFactoryInterface;
        }
        catch (Exception e) {
            throw new LogConfigurationException(e);
        }
    }
}

