/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DistanceUnits {
    MILES("miles", 3959.0, 24902.0),
    KILOMETERS("km", 6371.0, 40076.0);

    private static final double MILES_KILOMETRES_RATIO = 1.609344;
    private final String unit;
    private final double earthCircumference;
    private final double earthRadius;

    private DistanceUnits(String unit, double earthRadius, double earthCircumfence) {
        this.unit = unit;
        this.earthCircumference = earthCircumfence;
        this.earthRadius = earthRadius;
    }

    public static DistanceUnits findDistanceUnit(String unit) {
        if (MILES.getUnit().equalsIgnoreCase(unit) || unit.equalsIgnoreCase("mi")) {
            return MILES;
        }
        if (KILOMETERS.getUnit().equalsIgnoreCase(unit)) {
            return KILOMETERS;
        }
        throw new IllegalArgumentException("Unknown distance unit " + unit);
    }

    public double convert(double distance, DistanceUnits from) {
        if (from == this) {
            return distance;
        }
        return this == MILES ? distance / 1.609344 : distance * 1.609344;
    }

    public String getUnit() {
        return this.unit;
    }

    public double earthRadius() {
        return this.earthRadius;
    }

    public double earthCircumference() {
        return this.earthCircumference;
    }
}

