/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.TermFreqIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lookup {
    public abstract void init(NamedList var1, SolrCore var2);

    public void build(Dictionary dict) throws IOException {
        Iterator it = dict.getWordsIterator();
        TermFreqIterator tfit = it instanceof TermFreqIterator ? (TermFreqIterator)it : new TermFreqIterator.TermFreqIteratorWrapper(it);
        this.build(tfit);
    }

    protected abstract void build(TermFreqIterator var1) throws IOException;

    public abstract boolean store(File var1) throws IOException;

    public abstract boolean load(File var1) throws IOException;

    public abstract List<LookupResult> lookup(String var1, boolean var2, int var3);

    public abstract boolean add(String var1, Object var2);

    public abstract Object get(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LookupPriorityQueue
    extends PriorityQueue<LookupResult> {
        public LookupPriorityQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(LookupResult a, LookupResult b) {
            return a.value < b.value;
        }

        public LookupResult[] getResults() {
            int size = this.size();
            LookupResult[] res = new LookupResult[size];
            for (int i = size - 1; i >= 0; --i) {
                res[i] = (LookupResult)this.pop();
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LookupResult
    implements Comparable<LookupResult> {
        String key;
        float value;

        public LookupResult(String key, float value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "/" + this.value;
        }

        @Override
        public int compareTo(LookupResult o) {
            return this.key.compareTo(o.key);
        }
    }
}

