/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.noggit.JSONParser;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.XmlUpdateRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonLoader
extends ContentStreamLoader {
    static final Logger log = LoggerFactory.getLogger(JsonLoader.class);
    protected UpdateRequestProcessor processor;

    public JsonLoader(UpdateRequestProcessor processor) {
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
        this.errHeader = "JSONLoader: " + stream.getSourceInfo();
        Reader reader = null;
        try {
            reader = stream.getReader();
            if (XmlUpdateRequestHandler.log.isTraceEnabled()) {
                String body = IOUtils.toString((Reader)reader);
                XmlUpdateRequestHandler.log.trace("body", (Object)body);
                reader = new StringReader(body);
            }
            JSONParser parser = new JSONParser(reader);
            this.processUpdate(this.processor, parser);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.closeQuietly((Reader)reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    void processUpdate(UpdateRequestProcessor processor, JSONParser parser) throws IOException {
        int ev = parser.nextEvent();
        while (ev != 11) {
            switch (ev) {
                case 1: {
                    if (parser.wasKey()) {
                        CommitUpdateCommand cmd;
                        String v = parser.getString();
                        if (v.equals("add")) {
                            processor.processAdd(this.parseAdd(parser));
                            break;
                        }
                        if (v.equals("commit")) {
                            cmd = new CommitUpdateCommand(false);
                            cmd.waitSearcher = true;
                            cmd.waitFlush = true;
                            this.parseCommitOptions(parser, cmd);
                            processor.processCommit(cmd);
                            break;
                        }
                        if (v.equals("optimize")) {
                            cmd = new CommitUpdateCommand(true);
                            cmd.waitSearcher = true;
                            cmd.waitFlush = true;
                            this.parseCommitOptions(parser, cmd);
                            processor.processCommit(cmd);
                            break;
                        }
                        if (v.equals("delete")) {
                            processor.processDelete(this.parseDelete(parser));
                            break;
                        }
                        if (v.equals("rollback")) {
                            processor.processRollback(this.parseRollback(parser));
                            break;
                        }
                        throw new IOException("Unknown command: " + v + " [" + parser.getPosition() + "]");
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    log.info("can't have a value here! " + JSONParser.getEventString((int)ev) + " " + parser.getPosition());
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                default: {
                    System.out.println("UNKNOWN_EVENT_ID:" + ev);
                }
            }
            ev = parser.nextEvent();
        }
    }

    DeleteUpdateCommand parseDelete(JSONParser js) throws IOException {
        int ev;
        this.assertNextEvent(js, 7);
        DeleteUpdateCommand cmd = new DeleteUpdateCommand();
        cmd.fromPending = true;
        cmd.fromCommitted = true;
        while ((ev = js.nextEvent()) == 1) {
            String key = js.getString();
            if (js.wasKey()) {
                if ("id".equals(key)) {
                    cmd.id = js.getString();
                    continue;
                }
                if ("query".equals(key)) {
                    cmd.query = js.getString();
                    continue;
                }
                throw new IOException("Unknown key: " + key + " [" + js.getPosition() + "]");
            }
            throw new IOException("invalid string: " + key + " at [" + js.getPosition() + "]");
        }
        if (ev == 8) {
            if (cmd.id == null && cmd.query == null) {
                throw new IOException("Missing id or query for delete [" + js.getPosition() + "]");
            }
            return cmd;
        }
        throw new IOException("Got: " + JSONParser.getEventString((int)ev) + " at [" + js.getPosition() + "]");
    }

    RollbackUpdateCommand parseRollback(JSONParser js) throws IOException {
        this.assertNextEvent(js, 7);
        this.assertNextEvent(js, 8);
        return new RollbackUpdateCommand();
    }

    void parseCommitOptions(JSONParser js, CommitUpdateCommand cmd) throws IOException {
        int ev;
        this.assertNextEvent(js, 7);
        while ((ev = js.nextEvent()) == 1) {
            String key = js.getString();
            if (js.wasKey()) {
                if ("waitSearcher".equals(key)) {
                    cmd.waitSearcher = js.getBoolean();
                    continue;
                }
                if ("waitFlush".equals(key)) {
                    cmd.waitFlush = js.getBoolean();
                    continue;
                }
                throw new IOException("Unknown key: " + key + " [" + js.getPosition() + "]");
            }
            throw new IOException("invalid string: " + key + " at [" + js.getPosition() + "]");
        }
        if (ev == 8) {
            return;
        }
        throw new IOException("Got: " + JSONParser.getEventString((int)ev) + " at [" + js.getPosition() + "]");
    }

    AddUpdateCommand parseAdd(JSONParser js) throws IOException {
        int ev;
        this.assertNextEvent(js, 7);
        AddUpdateCommand cmd = new AddUpdateCommand();
        cmd.allowDups = false;
        float boost = 1.0f;
        while ((ev = js.nextEvent()) == 1) {
            if (js.wasKey()) {
                String key = js.getString();
                if ("doc".equals(key)) {
                    if (cmd.solrDoc != null) {
                        throw new IOException("multiple docs in same add command");
                    }
                    ev = this.assertNextEvent(js, 7);
                    cmd.solrDoc = this.parseDoc(ev, js);
                    continue;
                }
                if ("overwrite".equals(key)) {
                    cmd.allowDups = !js.getBoolean();
                    continue;
                }
                if ("commitWithin".equals(key)) {
                    cmd.commitWithin = (int)js.getLong();
                    continue;
                }
                if ("boost".equals(key)) {
                    boost = Float.parseFloat(js.getNumberChars().toString());
                    continue;
                }
                throw new IOException("Unknown key: " + key + " [" + js.getPosition() + "]");
            }
            throw new IOException("Should be a key  at [" + js.getPosition() + "]");
        }
        if (ev == 8) {
            if (cmd.solrDoc == null) {
                throw new IOException("missing solr document. " + js.getPosition());
            }
            cmd.solrDoc.setDocumentBoost(boost);
            cmd.overwriteCommitted = !cmd.allowDups;
            cmd.overwritePending = !cmd.allowDups;
            return cmd;
        }
        throw new IOException("Got: " + JSONParser.getEventString((int)ev) + " at [" + js.getPosition() + "]");
    }

    int assertNextEvent(JSONParser parser, int ev) throws IOException {
        int got = parser.nextEvent();
        if (ev != got) {
            throw new IOException("Expected: " + JSONParser.getEventString((int)ev) + " but got " + JSONParser.getEventString((int)got) + " at [" + parser.getPosition() + "]");
        }
        return got;
    }

    SolrInputDocument parseDoc(int ev, JSONParser js) throws IOException {
        Stack<Object> stack = new Stack<Object>();
        Object obj = null;
        boolean inArray = false;
        if (ev != 7) {
            throw new IOException("object should already be started");
        }
        block9: do {
            switch (ev) {
                case 1: {
                    if (js.wasKey()) {
                        obj = stack.peek();
                        String v = js.getString();
                        if (obj instanceof SolrInputField) {
                            SolrInputField field = obj;
                            if ("boost".equals(v)) {
                                ev = js.nextEvent();
                                if (ev != 3 && ev != 2 && ev != 4) {
                                    throw new IOException("boost should have number! " + JSONParser.getEventString((int)ev));
                                }
                                field.setBoost(Float.valueOf(js.getNumberChars().toString()).floatValue());
                                break;
                            }
                            if ("value".equals(v)) {
                                stack.push(field);
                                break;
                            }
                            throw new IOException("invalid key: " + v + " [" + js.getPosition() + "]");
                        }
                        if (obj instanceof SolrInputDocument) {
                            SolrInputDocument doc = obj;
                            SolrInputField f = doc.get((Object)v);
                            if (f == null) {
                                f = new SolrInputField(v);
                                doc.put(f.getName(), f);
                            }
                            stack.push(f);
                            break;
                        }
                        throw new IOException("hymmm [" + js.getPosition() + "]");
                    }
                    JsonLoader.addValToField(stack, js.getString(), inArray, js);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    JsonLoader.addValToField(stack, js.getNumberChars().toString(), inArray, js);
                    break;
                }
                case 5: {
                    JsonLoader.addValToField(stack, js.getBoolean(), inArray, js);
                    break;
                }
                case 7: {
                    if (stack.isEmpty()) {
                        stack.push(new SolrInputDocument());
                        break;
                    }
                    obj = stack.peek();
                    if (obj instanceof SolrInputField) continue block9;
                    throw new IOException("should not start new object with: " + obj + " [" + js.getPosition() + "]");
                }
                case 8: {
                    obj = stack.pop();
                    if (obj instanceof SolrInputDocument) {
                        return obj;
                    }
                    if (obj instanceof SolrInputField) continue block9;
                    throw new IOException("should not start new object with: " + obj + " [" + js.getPosition() + "]");
                }
                case 9: {
                    inArray = true;
                    break;
                }
                case 10: {
                    inArray = false;
                    stack.pop();
                    break;
                }
                default: {
                    System.out.println("UNKNOWN_EVENT_ID:" + ev);
                }
            }
        } while ((ev = js.nextEvent()) != 11);
        throw new IOException("should finish doc first!");
    }

    static void addValToField(Stack stack, Object val, boolean inArray, JSONParser js) throws IOException {
        Object obj = stack.peek();
        if (!(obj instanceof SolrInputField)) {
            throw new IOException("hymmm [" + js.getPosition() + "]");
        }
        SolrInputField f = inArray ? (SolrInputField)obj : (SolrInputField)stack.pop();
        float boost = f.getValue() == null ? f.getBoost() : 1.0f;
        f.addValue(val, boost);
    }
}

