/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

@Deprecated
public class TimeTrace {
    private Log log = LogFactory.getLog(TimeTrace.class);
    protected long timeToLogInfo = 1000000000L;
    protected long timeToLogWarn = 3000000000L;
    protected Map<String, CallStat> callCount = new HashMap<String, CallStat>();

    public TimeTrace() {
    }

    public TimeTrace(long timeToLogInfo, long timeToLogWarn) {
        this.setTimeToLogInfo(timeToLogInfo);
        this.setTimeToLogWarn(timeToLogWarn);
    }

    public void setTimeToLogInfo(long timeToLogInfoMs) {
        this.timeToLogInfo = timeToLogInfoMs * 1000000L;
    }

    public void setTimeToLogWarn(long timeToLogWarnMs) {
        this.timeToLogWarn = timeToLogWarnMs * 1000000L;
    }

    public Map<String, CallStat> getCallCount() {
        return this.callCount;
    }

    public static long getTime() {
        return System.nanoTime();
    }

    public void add(long startNs, String methodName) {
        this.add(startNs, TimeTrace.getTime(), methodName);
    }

    public void add(long startNs, long stopNs, String methodName) {
        long time = stopNs - startNs;
        CallStat calls = this.callCount.get(methodName);
        if (calls == null) {
            calls = new CallStat();
            this.callCount.put(methodName, calls);
        }
        ++calls.callNumber;
        calls.callTime += time;
        String timeString = StringUtil.convertTime(time);
        String msg = String.format("[%s] for method %s (%s)", timeString, methodName, calls);
        if (time > this.timeToLogWarn && this.log.isWarnEnabled()) {
            this.log.warn((Object)msg);
        } else if (time > this.timeToLogInfo && this.log.isInfoEnabled()) {
            this.log.info((Object)msg);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg);
        }
    }

    public static class CallStat {
        long callNumber = 0L;
        long callTime = 0L;

        public String toString() {
            String callTimeString = StringUtil.convertTime(this.callTime);
            String avgTimeString = StringUtil.convertTime(this.callTime / this.callNumber);
            return String.format("total call %s, total time %s, avg time %s", this.callNumber, callTimeString, avgTimeString);
        }
    }
}

