/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;

public class UnitDeptLinkDTO implements UnitDeptLink {

@WikittyField(fqn="UnitDeptLink.unit")    protected String unit;

@WikittyField(fqn="UnitDeptLink.department")    protected String department;

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public String getUnit() {
        return unit;
}

    @Override
    public void setUnit(String unit) {
        this.unit=unit;
        modificationCount++;
}

    @Override
    public String getDepartment() {
        return department;
}

    @Override
    public void setDepartment(String department) {
        this.department=department;
        modificationCount++;
}

    public UnitDeptLinkDTO() {
}

    public UnitDeptLinkDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof UnitDeptLink)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        UnitDeptLink sourceCopy = (UnitDeptLink)source;

        setUnit(sourceCopy.getUnit());

        setDepartment(sourceCopy.getDepartment());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

} //UnitDeptLinkDTO
