/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class DepartmentHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private DepartmentHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_NAME, name);
        return oldValue;
}

    public static String getFullName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_FULLNAME);
        return value;
}

    public static String setFullName(Wikitty wikitty, String fullName) {
        String oldValue = getFullName(wikitty);
        wikitty.setField(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_FULLNAME, fullName);
        return oldValue;
}

    public static Set<String> getUnitDeptLink(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK, String.class);
        return result;
}

    public static void setUnitDeptLink(Wikitty wikitty, Set<String> unitDeptLink) {
        wikitty.setField(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK, unitDeptLink);
}

    public static void addAllUnitDeptLink(Wikitty wikitty, Collection<String> unitDeptLink) {
        if(unitDeptLink != null){
            for (String v:unitDeptLink){
                addUnitDeptLink(wikitty, v);
            }
        }
}

    public static void addUnitDeptLink(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK, v);
        }
}

    public static void removeUnitDeptLink(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK, v);
        }
}

    public static void clearUnitDeptLink(Wikitty wikitty) {
        wikitty.clearField(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK);
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_NAME);
            Object f2 = w2.getFieldAsObject(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_FULLNAME);
            Object f2 = w2.getFieldAsObject(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_FULLNAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK);
            Object f2 = w2.getFieldAsObject(Department.EXT_DEPARTMENT, Department.FIELD_DEPARTMENT_UNITDEPTLINK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Department.EXT_DEPARTMENT);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : DepartmentAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Department.EXT_DEPARTMENT);
}

} //DepartmentHelper
