/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class AgentHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private AgentHelper() {// empty
}

    public static String getRefNumber(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Agent.EXT_AGENT, Agent.FIELD_AGENT_REFNUMBER);
        return value;
}

    public static String setRefNumber(Wikitty wikitty, String refNumber) {
        String oldValue = getRefNumber(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_REFNUMBER, refNumber);
        return oldValue;
}

    public static String getState(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATE);
        return value;
}

    public static String setState(Wikitty wikitty, String state) {
        String oldValue = getState(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATE, state);
        return oldValue;
}

    public static Date getStateDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATEDATE);
        return value;
}

    public static Date setStateDate(Wikitty wikitty, Date stateDate) {
        Date oldValue = getStateDate(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATEDATE, stateDate);
        return oldValue;
}

    public static Boolean getAgent(Wikitty wikitty) {
        Boolean value = wikitty.getFieldAsBoolean(Agent.EXT_AGENT, Agent.FIELD_AGENT_AGENT);
        return value;
}

    public static Boolean setAgent(Wikitty wikitty, Boolean agent) {
        Boolean oldValue = getAgent(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_AGENT, agent);
        return oldValue;
}

    public static String getJobType(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPE);
        return value;
}

    public static String setJobType(Wikitty wikitty, String jobType) {
        String oldValue = getJobType(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPE, jobType);
        return oldValue;
}

    public static String getAddress(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Agent.EXT_AGENT, Agent.FIELD_AGENT_ADDRESS);
        return value;
}

    public static String setAddress(Wikitty wikitty, String address) {
        String oldValue = getAddress(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_ADDRESS, address);
        return oldValue;
}

    public static String getJobTypeReference(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPEREFERENCE);
        return value;
}

    public static String setJobTypeReference(Wikitty wikitty, String jobTypeReference) {
        String oldValue = getJobTypeReference(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPEREFERENCE, jobTypeReference);
        return oldValue;
}

    public static String getPepi(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Agent.EXT_AGENT, Agent.FIELD_AGENT_PEPI);
        return value;
}

    public static String setPepi(Wikitty wikitty, String pepi) {
        String oldValue = getPepi(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_PEPI, pepi);
        return oldValue;
}

    public static String getCati(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Agent.EXT_AGENT, Agent.FIELD_AGENT_CATI);
        return value;
}

    public static String setCati(Wikitty wikitty, String cati) {
        String oldValue = getCati(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_CATI, cati);
        return oldValue;
}

    public static String getDepartment(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Agent.EXT_AGENT, Agent.FIELD_AGENT_DEPARTMENT);
        return value;
}

    public static String setDepartment(Wikitty wikitty, String department) {
        String oldValue = getDepartment(wikitty);
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_DEPARTMENT, department);
        return oldValue;
}

    public static Set<String> getUnit(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT, String.class);
        return result;
}

    public static void setUnit(Wikitty wikitty, Set<String> unit) {
        wikitty.setField(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT, unit);
}

    public static void addAllUnit(Wikitty wikitty, Collection<String> unit) {
        if(unit != null){
            for (String v:unit){
                addUnit(wikitty, v);
            }
        }
}

    public static void addUnit(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT, v);
        }
}

    public static void removeUnit(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT, v);
        }
}

    public static void clearUnit(Wikitty wikitty) {
        wikitty.clearField(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT);
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_REFNUMBER);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_REFNUMBER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATE);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATEDATE);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_STATEDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_AGENT);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_AGENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPE);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_ADDRESS);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPEREFERENCE);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_JOBTYPEREFERENCE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_PEPI);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_PEPI);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_CATI);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_CATI);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_DEPARTMENT);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_DEPARTMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT);
            Object f2 = w2.getFieldAsObject(Agent.EXT_AGENT, Agent.FIELD_AGENT_UNIT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Agent.EXT_AGENT);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : AgentAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Agent.EXT_AGENT);
}

} //AgentHelper
