#!/bin/bash

BACKUP_DATE=$(date +%Y%m%d%H%M%S)
if [ -d NEW/jre ]; then
  oldVersion=`cat jre/version.appup`
  newVersion=`cat NEW/jre/version.appup`
  echo \"Update jre version $oldVersion to $newVersion\"
  mkdir -p OLD
  backupdir=OLD/jre-$oldVersion-$BACKUP_DATE
  echo \"Backup jre old version to $backupdir\"
  mv jre $backupdir
  mv NEW/jre .
fi

chmod +x jre/bin/java
if [ ! -h java ]; then
  ln -sr jre/bin/java java
fi

if [ -d NEW/launcher ]; then
  oldVersion=`cat launcher/version.appup`
  newVersion=`cat NEW/launcher/version.appup`
  echo \"Update launcher version $oldVersion to $newVersion\"
  mkdir -p OLD
  backupdir=OLD/launcher-$oldVersion-$BACKUP_DATE
  echo \"Backup launcher old version to $backupdir\"
  mv tutti.sh launcher/
  mv launcher $backupdir
  mv NEW/launcher .
  rm launcher/*.exe
  rm launcher/*.bat
  mv launcher/tutti.sh .
  chmod +x tutti.sh
fi

./tutti.sh