/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.action.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditCatchesAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(EditCatchesAction.class);

    public EditCatchesAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_FISHING_OPERATION);
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)this.getContext().isProgramFilled());
        Preconditions.checkState((boolean)this.getContext().isCruiseFilled());
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit operations of cruise: " + this.getContext().getCruiseId()));
        }
        this.getContext().setValidationContext("edit");
        super.doAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FishingOperationsUI currentBoby = (FishingOperationsUI)((MainUIHandler)EditCatchesAction.this.getHandler()).getCurrentBody();
                EditFishingOperationUI fishingOperationTabContent = currentBoby.getFishingOperationTabContent();
                JComponent componentToFocus = fishingOperationTabContent.getHandler().getComponentToFocus();
                componentToFocus.requestFocusInWindow();
            }
        });
    }
}

