/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.math.BigInteger;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AlterSequenceStatement;

@DatabaseChange(name="alterSequence", description="Alter properties of an existing sequence", priority=1, appliesTo={"sequence"})
public class AlterSequenceChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String sequenceName;
    private BigInteger incrementBy;
    private BigInteger maxValue;
    private BigInteger minValue;
    private Boolean ordered;

    @DatabaseChangeProperty(mustEqualExisting="sequence.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="sequence.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="sequence")
    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    @DatabaseChangeProperty(description="New amount the sequence should increment by")
    public BigInteger getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(BigInteger incrementBy) {
        this.incrementBy = incrementBy;
    }

    @DatabaseChangeProperty(description="New maximum value for the sequence")
    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigInteger maxValue) {
        this.maxValue = maxValue;
    }

    @DatabaseChangeProperty(description="New minimum value for the sequence")
    public BigInteger getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigInteger minValue) {
        this.minValue = minValue;
    }

    @DatabaseChangeProperty(description="Does the sequence need to be guaranteed to be genererated inm the order of request?")
    public Boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new AlterSequenceStatement(this.getCatalogName(), this.getSchemaName(), this.getSequenceName()).setIncrementBy(this.getIncrementBy()).setMaxValue(this.getMaxValue()).setMinValue(this.getMinValue()).setOrdered(this.isOrdered())};
    }

    @Override
    public String getConfirmationMessage() {
        return "Sequence " + this.getSequenceName() + " altered";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

