package fr.ifremer.tutti.ui.swing.launcher;

/*
 * #%L
 * Tutti :: Launcher
 * %%
 * Copyright (C) 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashSet;
import java.util.Set;

/**
 * Created on 2/2/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 1.0.2
 */
public class ExitCodes {

    protected static final ExitCode NORMAL_EXIT_CODE = new ExitCode(0, false);

    protected static final ExitCode APPLICATION_UPDATE_EXIT_CODE = new ExitCode(88, true);

    protected static final ExitCode RUNTIME_UPDATE_EXIT_CODE = new ExitCode(90, true);

    protected static Set<ExitCode> KNOWN_EXIT_CODES;

    public static ExitCode getExitCode(int code) {

        if (KNOWN_EXIT_CODES == null) {
            KNOWN_EXIT_CODES = new HashSet<>();
            KNOWN_EXIT_CODES.add(RUNTIME_UPDATE_EXIT_CODE);
            KNOWN_EXIT_CODES.add(APPLICATION_UPDATE_EXIT_CODE);
            KNOWN_EXIT_CODES.add(NORMAL_EXIT_CODE);
        }

        ExitCode result = null;

        for (ExitCode exitCode : KNOWN_EXIT_CODES) {
            if (code == exitCode.getExitCode()) {
                result = exitCode;
                break;
            }
        }

        if (result == null) {
            result = new ExitCode(code, false);
        }

        return result;

    }

    public static boolean isNormalExitCode(ExitCode exitCode) {
        return NORMAL_EXIT_CODE.equals(exitCode);
    }

    public static boolean isRuntimeUpdateExitCode(ExitCode exitCode) {
        return RUNTIME_UPDATE_EXIT_CODE.equals(exitCode);
    }

    public static boolean isApplicationUpdateExitCode(ExitCode exitCode) {
        return APPLICATION_UPDATE_EXIT_CODE.equals(exitCode);
    }

}
