/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.export;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.ui.models.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class ExportNameListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, ExportInfo> exportCache = new HashMap<String, ExportInfo>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String exportName = (String)value;
        try {
            ExportInfo export = this.exportCache.get(exportName);
            if (export == null) {
                ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                export = (ExportInfo)storage.getNewInstance();
                this.exportCache.put(exportName, export);
            }
            text = RendererHelper.getNameAndDocListString(exportName, export.getDescription());
        }
        catch (Exception e) {
            text = RendererHelper.getNameAndCompListString(exportName);
        }
        c.setText(text);
        return c;
    }
}

