/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.model;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FactorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1686424876690392268L;
    protected Map<String, Icon> iconCache = new HashMap<String, Icon>();

    public FactorTreeCellRenderer() {
        this.iconCache.put("c", Resource.getIcon((String)"/icons/factors/brick_c.png"));
        this.iconCache.put("d", Resource.getIcon((String)"/icons/factors/brick_d.png"));
        this.iconCache.put("dg", Resource.getIcon((String)"/icons/factors/bricks_d.png"));
        this.iconCache.put("cg", Resource.getIcon((String)"/icons/factors/bricks_c.png"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Object icon = null;
        Object text = null;
        if (value instanceof Factor) {
            Factor factor = (Factor)value;
            if (value instanceof FactorGroup) {
                FactorGroup factorGroup = (FactorGroup)value;
                if (factorGroup == tree.getModel().getRoot()) {
                    text = I18n.t((String)"isisfish.sensitivity.factors", (Object[])new Object[0]);
                } else {
                    if (factorGroup.isDiscrete()) {
                        icon = "d";
                    } else if (factorGroup.isContinuous()) {
                        icon = "c";
                    }
                    icon = (String)icon + "g";
                    text = factor.getName();
                }
            } else {
                Domain domain = factor.getDomain();
                icon = domain instanceof ContinuousDomain ? "c" : "d";
                text = factor.getName();
            }
            if (StringUtils.isNotBlank((CharSequence)factor.getEquationVariableName())) {
                text = (String)text + "." + factor.getEquationVariableName();
            }
        }
        c.setIcon(this.iconCache.get(icon));
        c.setText((String)text);
        return c;
    }
}

