/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.variable;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.entities.VariableDAO;
import fr.ifremer.isisfish.entities.VariableType;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.variable.EntityVariableUI;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import java.awt.CardLayout;
import java.util.List;
import javax.swing.JList;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class EntityVariableHandler
extends InputContentHandler<EntityVariableUI> {
    private static final Log log = LogFactory.getLog(EntityVariableHandler.class);

    protected EntityVariableHandler(EntityVariableUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((EntityVariableUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> this.reloadVariables());
        ((EntityVariableUI)this.inputContentUI).addPropertyChangeListener("variable", evt -> {
            if (evt.getNewValue() == null) {
                ((EntityVariableUI)this.inputContentUI).matrixPanel.setMatrix(null);
            }
        });
    }

    protected void reloadVariables() {
        GenericListModel model;
        List variables;
        block6: {
            ((EntityVariableUI)this.inputContentUI).getVariablesList().clearSelection();
            variables = null;
            model = (GenericListModel)((EntityVariableUI)this.inputContentUI).getVariablesList().getModel();
            TopiaEntityContextable bean = ((EntityVariableUI)this.inputContentUI).getBean();
            if (bean != null) {
                try {
                    TopiaContext context = ((EntityVariableUI)this.inputContentUI).getTopiaContext();
                    VariableDAO dao = IsisFishDAOHelper.getVariableDAO(context);
                    variables = dao.findAllByEntityId(bean.getTopiaId());
                }
                catch (TopiaException ex) {
                    throw new IsisFishRuntimeException("Can't init view", ex);
                }
                try {
                    String name = BeanUtils.getProperty((Object)((EntityVariableUI)this.inputContentUI).getBean(), (String)"name");
                    ((EntityVariableUI)this.inputContentUI).getVariableEntityName().setText(name);
                }
                catch (Exception ex) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Can't get entity name", (Throwable)ex);
                    }
                    break block6;
                }
            }
            ((EntityVariableUI)this.inputContentUI).getVariableEntityName().setText("");
        }
        model.setElementList(variables);
    }

    public void addNewVariable(EntityVariableUI view) {
        try {
            TopiaContext context = view.getTopiaContext();
            VariableDAO dao = IsisFishDAOHelper.getVariableDAO(context);
            Variable variable = (Variable)dao.create(new Object[]{"entityId", view.getBean().getTopiaId(), "name", I18n.t((String)"isisfish.variables.defaultname", (Object[])new Object[0])});
            GenericListModel model = (GenericListModel)view.getVariablesList().getModel();
            List<Variable> variables = model.getElementList();
            variables.add(variable);
            model.setElementList(variables);
            view.getVariablesList().setSelectedValue(variable, true);
        }
        catch (TopiaException ex) {
            throw new IsisFishRuntimeException("Can't add variable", ex);
        }
    }

    public void deleteVariable(EntityVariableUI view) {
        JList<Variable> variableList = view.getVariablesList();
        Variable variable = variableList.getSelectedValue();
        try {
            TopiaContext context = view.getTopiaContext();
            VariableDAO dao = IsisFishDAOHelper.getVariableDAO(context);
            dao.delete((TopiaEntity)variable);
            context.commitTransaction();
            view.getVariablesList().clearSelection();
            GenericListModel model = (GenericListModel)view.getVariablesList().getModel();
            List variables = model.getElementList();
            variables.remove(variable);
            model.setElementList(variables);
        }
        catch (TopiaException ex) {
            throw new IsisFishRuntimeException("Can't delete variable", ex);
        }
    }

    public void showSelectedVariable(EntityVariableUI view) {
        JList<Variable> variableList = view.getVariablesList();
        Variable variable = variableList.getSelectedValue();
        view.setVariable(variable);
        view.getSaveVerifier().addCurrentEntity(variable);
    }

    public void showSelectedType(EntityVariableUI view) {
        CardLayout cardLayout = view.getVariableTypeLayout();
        VariableType type = (VariableType)((Object)view.getVariableTypeCombo().getSelectedItem());
        view.getVariable().setType(type);
        switch (type) {
            case DOUBLE: {
                cardLayout.show(view.getVariableTypePanel(), "doubletype");
                break;
            }
            case EQUATION: {
                cardLayout.show(view.getVariableTypePanel(), "equationtype");
                break;
            }
            case MATRIX: {
                cardLayout.show(view.getVariableTypePanel(), "matrixtype");
            }
        }
    }

    public void saveVariable(EntityVariableUI view) {
        JList<Variable> variableList = view.getVariablesList();
        Variable variable = variableList.getSelectedValue();
        variable.setName(view.getVariableNameField().getText().trim());
        VariableType type = (VariableType)((Object)view.getVariableTypeCombo().getSelectedItem());
        switch (type) {
            case DOUBLE: {
                try {
                    double v = Double.parseDouble(view.getVariableDoubleValue().getText().trim());
                    variable.setDoubleValue(v);
                }
                catch (NumberFormatException ex) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)"Can't parse double value as double", (Throwable)ex);
                }
                break;
            }
            case MATRIX: {
                variable.setMatrixValue(view.getMatrixPanel().getMatrix());
            }
        }
        view.getSaveVerifier().save();
        GenericListModel model = (GenericListModel)view.getVariablesList().getModel();
        List variables = model.getElementList();
        model.setElementList(variables);
    }
}

