/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.result.ResultInfoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;

public class ResultManager {
    private static Log log = LogFactory.getLog(ResultManager.class);
    protected SimulationContext context = null;
    protected Set<SimulationResultListener> listeners = new LinkedHashSet<SimulationResultListener>();
    protected SimulationResultGetter getter = null;
    protected transient Set<String> enabledResult = null;

    public ResultManager(SimulationContext context) {
        this.context = context;
    }

    protected void addSimulationResultListener(SimulationResultListener l) {
        this.listeners.add(l);
        if (l instanceof SimulationResultGetter) {
            this.getter = (SimulationResultGetter)((Object)l);
        }
    }

    protected void removeSimulationResultListener(SimulationResultListener l) {
        this.listeners.remove(l);
        if (l == this.getter) {
            this.getter = null;
            for (SimulationResultListener i : this.listeners) {
                if (!(i instanceof SimulationResultGetter)) continue;
                this.getter = (SimulationResultGetter)((Object)i);
                break;
            }
        }
    }

    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null) {
            Map<ExportInfo, Observation> optimizationExportsObservations;
            Optimization optimization;
            Objective objective;
            List<SimulationPlan> list;
            List<Rule> list2;
            List<SensitivityExport> sensitivityExports;
            SimulationParameter param = this.context.getSimulationStorage().getParameter();
            Set<String> requestedResult = ResultInfoHelper.cleanResultNames(param.getResultEnabled());
            List<String> exportNames = param.getExportNames();
            if (exportNames != null) {
                for (String string : exportNames) {
                    ExportStorage exportStorage = ExportStorage.getExport(string, new CodeSourceStorage.Location[0]);
                    try {
                        ExportInfo exportInfo = (ExportInfo)exportStorage.getNewInstance();
                        requestedResult.addAll(Arrays.asList(exportInfo.getNecessaryResult()));
                    }
                    catch (IsisFishException isisFishException) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n.t((String)"Can't instanciate export %1$s", (Object[])new Object[]{string}), (Throwable)isisFishException);
                    }
                }
            }
            if ((sensitivityExports = param.getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    requestedResult.addAll(Arrays.asList(sensitivityExport.getNecessaryResult()));
                }
            }
            if ((list2 = param.getRules()) != null) {
                for (Rule rule : list2) {
                    requestedResult.addAll(Arrays.asList(rule.getNecessaryResult()));
                }
            }
            if ((list = param.getSimulationPlans()) != null) {
                for (SimulationPlan plan : list) {
                    requestedResult.addAll(Arrays.asList(plan.getNecessaryResult()));
                }
            }
            if ((objective = param.getObjective()) != null) {
                requestedResult.addAll(Arrays.asList(objective.getNecessaryResult()));
            }
            if ((optimization = param.getOptimization()) != null) {
                requestedResult.addAll(Arrays.asList(optimization.getNecessaryResult()));
            }
            if ((optimizationExportsObservations = param.getOptimizationExportsObservations()) != null) {
                for (ExportInfo export : optimizationExportsObservations.keySet()) {
                    requestedResult.addAll(Arrays.asList(export.getNecessaryResult()));
                }
            }
            requestedResult.addAll(this.simulationEquationsResults());
            this.enabledResult = ResultInfoHelper.extractAllNecessaryResults(requestedResult);
            if (log.isInfoEnabled()) {
                log.info((Object)("Enabled result: " + String.valueOf(this.enabledResult)));
            }
        }
        boolean result = this.enabledResult.contains(name);
        return result;
    }

    protected Set<String> simulationEquationsResults() {
        HashSet<String> equationResults = new HashSet<String>();
        SimulationParameter param = this.context.getSimulationStorage().getParameter();
        List<Population> populations = param.getPopulations();
        for (Population population : populations) {
            this.extractEquationResult(equationResults, population.getGrowth(), population.getMaturityOgiveEquation(), population.getMeanWeight(), population.getNaturalDeathRate(), population.getPrice(), population.getReproductionEquation(), population.getFishingMortalityOtherFleets(), population.getGrowthReverse(), population.getReproductionRateEquation(), population.getRecruitmentEquation(), population.getCapturabilityEquation());
            List<PopulationSeasonInfo> populationSeasonInfos = population.getPopulationSeasonInfo();
            for (PopulationSeasonInfo populationSeasonInfo : populationSeasonInfos) {
                this.extractEquationResult(equationResults, populationSeasonInfo.getEmigrationEquation(), populationSeasonInfo.getImmigrationEquation(), populationSeasonInfo.getMigrationEquation());
            }
        }
        List<Strategy> strategies = param.getStrategies();
        for (Strategy strategy : strategies) {
            this.extractEquationResult(equationResults, strategy.getInactivityEquation());
            SetOfVessels setOfVessels = strategy.getSetOfVessels();
            if (setOfVessels == null) continue;
            this.extractEquationResult(equationResults, setOfVessels.getTechnicalEfficiencyEquation());
            Collection<EffortDescription> possibleMetiers = this.orEmpty(setOfVessels.getPossibleMetiers());
            for (EffortDescription possibleMetier : possibleMetiers) {
                Gear gear;
                Metier metier = possibleMetier.getPossibleMetiers();
                if (metier == null || (gear = metier.getGear()) == null) continue;
                Collection<Selectivity> populationSelectivity = this.orEmpty(gear.getPopulationSelectivity());
                for (Selectivity selectivity : populationSelectivity) {
                    this.extractEquationResult(equationResults, selectivity.getEquation());
                }
                List<MetierSeasonInfo> metierSeasonInfos = this.orEmpty(metier.getMetierSeasonInfo());
                for (MetierSeasonInfo metierSeasonInfo : metierSeasonInfos) {
                    Collection<TargetSpecies> speciesTargetSpecies = this.orEmpty(metierSeasonInfo.getSpeciesTargetSpecies());
                    for (TargetSpecies speciesTargetSpecy : speciesTargetSpecies) {
                        this.extractEquationResult(equationResults, speciesTargetSpecy.getTargetFactorEquation());
                    }
                }
            }
        }
        List list = this.context.getVariableDAO().findAll();
        for (Variable variable : list) {
            this.extractEquationResult(equationResults, variable.getEquationValue());
        }
        return equationResults;
    }

    protected <T> List<T> orEmpty(List<T> coll) {
        return coll == null ? Collections.emptyList() : coll;
    }

    protected <T> Collection<T> orEmpty(Collection<T> coll) {
        return coll == null ? Collections.emptyList() : coll;
    }

    private void extractEquationResult(Set<String> equationResults, Equation ... equations) {
        for (Equation equation : equations) {
            if (equation == null) continue;
            try {
                String[] results = equation.evaluateNecessaryResult();
                equationResults.addAll(Arrays.asList(results));
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Equation is not compilable", (Throwable)ex);
            }
        }
    }

    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        log.debug((Object)"addActiveRule not implemented");
    }

    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            for (SimulationResultListener l : this.listeners) {
                l.addResult(this.context, step, name + " " + String.valueOf(pop), mat);
            }
        }
    }

    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            for (SimulationResultListener l : this.listeners) {
                l.addResult(this.context, step, name, mat);
            }
        }
    }

    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        name = (String)name + " " + String.valueOf(pop);
        return this.getMatrix(step, (String)name);
    }

    public MatrixND getMatrix(TimeStep step, String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, step, name);
        }
        return result;
    }

    public MatrixND getMatrix(List<TimeStep> steps, Population pop, String name) {
        name = (String)name + " " + String.valueOf(pop);
        return this.getMatrix(steps, (String)name);
    }

    public MatrixND getMatrix(List<TimeStep> steps, String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, steps, name);
        }
        return result;
    }

    public MatrixND getMatrix(Population pop, String name) {
        name = (String)name + " " + String.valueOf(pop);
        return this.getMatrix((String)name);
    }

    public MatrixND getMatrix(String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, name);
        }
        return result;
    }
}

