/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.beans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UserWebToken
implements Serializable {
    public static final String CLAIMS_USER_ID = "userId";
    public static final String CLAIMS_FIRST_NAME = "firstName";
    public static final String CLAIMS_LAST_NAME = "lastName";
    public static final String CLAIMS_ROLE = "role";
    protected String userId;
    protected String firstName;
    protected String lastName;
    protected String role;

    public UserWebToken(String userId, String firstName, String lastName, String role) {
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.role = role;
    }

    public UserWebToken(Map<String, Object> claims) {
        this.userId = (String)claims.get(CLAIMS_USER_ID);
        this.firstName = (String)claims.get(CLAIMS_FIRST_NAME);
        this.lastName = (String)claims.get(CLAIMS_LAST_NAME);
        this.role = ((String)claims.get(CLAIMS_ROLE)).toUpperCase();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Map<String, Object> toJwtClaims() {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(CLAIMS_USER_ID, this.userId);
        claims.put(CLAIMS_FIRST_NAME, this.firstName);
        claims.put(CLAIMS_LAST_NAME, this.lastName);
        claims.put(CLAIMS_ROLE, this.role);
        return claims;
    }

    public static Map<String, Object> toJwtClaims(String userId, String firstName, String lastName, String role) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(CLAIMS_USER_ID, userId);
        claims.put(CLAIMS_FIRST_NAME, firstName);
        claims.put(CLAIMS_LAST_NAME, lastName);
        claims.put(CLAIMS_ROLE, role.toUpperCase());
        return claims;
    }
}

