/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services;

import com.google.common.base.Preconditions;
import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.persistence.CoselmarTopiaApplicationContext;
import fr.ifremer.coselmar.persistence.CoselmarTopiaPersistenceContext;
import fr.ifremer.coselmar.services.CoselmarApplicationContext;
import fr.ifremer.coselmar.services.CoselmarServicesContext;
import fr.ifremer.coselmar.services.DefaultCoselmarServicesContext;
import fr.ifremer.coselmar.services.config.CoselmarServicesConfig;
import fr.ifremer.coselmar.services.indexation.LuceneUtils;
import fr.ifremer.coselmar.services.v1.InitialisationService;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;

public class CoselmarServicesApplicationContext
implements CoselmarApplicationContext {
    private static Log log = LogFactory.getLog(CoselmarServicesApplicationContext.class);
    protected static final String APPLICATION_CONTEXT_PARAMETER = "coselmar_CoselmarApplicationContext";
    protected static CoselmarServicesApplicationContext applicationContext;
    protected AtomicBoolean started;
    protected AtomicBoolean closed;
    protected CoselmarTopiaApplicationContext topiaApplicationContext;
    protected CoselmarServicesConfig applicationConfig;
    protected LuceneUtils luceneUtils;

    public static CoselmarServicesApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            CoselmarServicesConfig applicationConfig = new CoselmarServicesConfig("coselmar-services.properties");
            Map topiaProperties = applicationConfig.getTopiaProperties();
            CoselmarTopiaApplicationContext coselmarTopiaApplicationContext = new CoselmarTopiaApplicationContext(topiaProperties);
            LuceneUtils luceneUtils = new LuceneUtils(applicationConfig);
            applicationContext = new CoselmarServicesApplicationContext(applicationConfig, coselmarTopiaApplicationContext, luceneUtils);
            applicationContext.init();
        }
        return applicationContext;
    }

    public static CoselmarServicesApplicationContext getApplicationContext(ServletContext servletContext) {
        CoselmarServicesApplicationContext result = (CoselmarServicesApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static void setApplicationContext(CoselmarServicesApplicationContext applicationContext) {
        CoselmarServicesApplicationContext.applicationContext = applicationContext;
    }

    public static void setApplicationContext(ServletContext servletContext, CoselmarServicesApplicationContext applicationContext) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, (Object)applicationContext);
    }

    protected CoselmarServicesApplicationContext(CoselmarServicesConfig applicationConfig, CoselmarTopiaApplicationContext topiaApplicationContext, LuceneUtils luceneUtils) {
        Preconditions.checkNotNull((Object)applicationConfig, (Object)"Configuration can not be null!");
        Preconditions.checkNotNull((Object)topiaApplicationContext, (Object)"topiaApplicationContext can not be null!");
        this.applicationConfig = applicationConfig;
        this.topiaApplicationContext = topiaApplicationContext;
        this.luceneUtils = luceneUtils;
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    public CoselmarTopiaApplicationContext getTopiaApplicationContext() {
        return this.topiaApplicationContext;
    }

    public CoselmarServicesConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public CoselmarTopiaPersistenceContext newPersistenceContext() {
        CoselmarTopiaPersistenceContext persistenceContext = this.topiaApplicationContext.newPersistenceContext();
        return persistenceContext;
    }

    public LuceneUtils getLuceneUtils() {
        return this.luceneUtils;
    }

    public CoselmarServicesContext newServiceContext(CoselmarPersistenceContext persistenceContext, Locale locale) {
        DefaultCoselmarServicesContext newServiceContext = new DefaultCoselmarServicesContext();
        newServiceContext.setCoselmarServicesConfig(this.applicationConfig);
        newServiceContext.setLuceneUtils(this.luceneUtils);
        newServiceContext.setTopiaApplicationContext(this.topiaApplicationContext);
        newServiceContext.setPersistenceContext(persistenceContext);
        newServiceContext.setLocale(locale);
        return newServiceContext;
    }

    public void close() {
        if (this.closed.get()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Already closed");
            }
            return;
        }
        if (!this.started.get()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Not started");
            }
            return;
        }
        if (this.topiaApplicationContext != null && !this.topiaApplicationContext.isClosed()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"stopping Coselmar, will close persistence context");
            }
            this.topiaApplicationContext.close();
        }
        if (this.luceneUtils != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Close Lucene Writer");
            }
            this.luceneUtils.closeWriter();
        }
        this.closed.set(true);
        this.started.set(false);
    }

    public void init() {
        if (this.started.get()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Already started!");
            }
            return;
        }
        Preconditions.checkState((this.applicationConfig != null ? 1 : 0) != 0, (Object)"No configuration initialized!");
        Preconditions.checkState((this.topiaApplicationContext != null ? 1 : 0) != 0, (Object)"No topiaApplicationContext initialized!");
        Preconditions.checkState((this.luceneUtils != null ? 1 : 0) != 0, (Object)"No LuceneUtils initialized!");
        if (this.applicationConfig.isLogConfigurationProvided()) {
            File log4jConfigurationFile = this.applicationConfig.getLogConfigurationFile();
            String log4jConfigurationFileAbsolutePath = log4jConfigurationFile.getAbsolutePath();
            if (log4jConfigurationFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("will use logging configuration " + log4jConfigurationFileAbsolutePath));
                }
                LogManager.resetConfiguration();
                PropertyConfigurator.configure((String)log4jConfigurationFileAbsolutePath);
                log = LogFactory.getLog(CoselmarServicesApplicationContext.class);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("there is no file " + log4jConfigurationFileAbsolutePath + ". Default logging configuration will be used."));
            }
        } else {
            log.info((Object)"will use default logging configuration");
        }
        DefaultI18nInitializer initializer = new DefaultI18nInitializer("coselmar-i18n");
        initializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)initializer, (Locale)Locale.FRANCE);
        CoselmarTopiaPersistenceContext persistenceContext = this.newPersistenceContext();
        CoselmarServicesContext serviceContext = this.newServiceContext((CoselmarPersistenceContext)persistenceContext, Locale.FRANCE);
        ((InitialisationService)serviceContext.newService(InitialisationService.class)).createDefaultUsers();
        persistenceContext.close();
        this.started.set(true);
    }
}

