package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Dec 11 16:13:01 UTC 2014")
public abstract class CoselmarUserGroupAbstract extends AbstractTopiaEntity implements CoselmarUserGroup {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : question
     */
    protected Question question;

    /**
     * Nom de l'attribut en BD : members
     */
    protected Set<CoselmarUser> members;

    private static final long serialVersionUID = 3618986664161064247L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_QUESTION, Question.class, question);
        visitor.visit(this, PROPERTY_MEMBERS, Set.class, CoselmarUser.class, members);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setQuestion(Question question) {
        this.question = question;
    }

    @Override
    public Question getQuestion() {
        Question result = this.question;
        return result;
    }

    @Override
    public void addMembers(CoselmarUser members) {
        if (this.members == null) {
            this.members = new HashSet<CoselmarUser>();
        }
        this.members.add(members);
    }

    @Override
    public void addAllMembers(Set<CoselmarUser> members) {
        if (members == null) {
            return;
        }
        for (CoselmarUser item : members) {
            addMembers(item);
        }
    }

    @Override
    public void setMembers(Set<CoselmarUser> members) {
        this.members = members;
    }

    @Override
    public void removeMembers(CoselmarUser members) {
        if (this.members == null || !this.members.remove(members)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearMembers() {
        if (this.members == null) {
            return;
        }
        this.members.clear();
    }

    @Override
    public Set<CoselmarUser> getMembers() {
        return members;
    }

    @Override
    public CoselmarUser getMembersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(members, topiaId);
    }

    @Override
    public Set<String> getMembersTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.CoselmarUser> tmp = getMembers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMembers() {
        if (members == null) {
            return 0;
        }
        return members.size();
    }

    @Override
    public boolean isMembersEmpty() {
        int size = sizeMembers();
        return size == 0;
    }

    @Override
    public boolean isMembersNotEmpty() {
        boolean empty = isMembersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMembers(CoselmarUser members) {
        boolean contains = this.members !=null && this.members.contains(members);
        return contains;
    }

} //CoselmarUserGroupAbstract
