/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.config.CloudWordUtils;
import fr.ifremer.coselmar.services.CoselmarSimpleServiceSupport;
import fr.ifremer.coselmar.services.indexation.LuceneUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;

public class DocumentsIndexationService
extends CoselmarSimpleServiceSupport {
    protected static final String DOCUMENT_ID_INDEX_PROPERTY = "documentId";
    protected static final String DOCUMENT_NAME_INDEX_PROPERTY = "documentName";
    protected static final String DOCUMENT_AUTHORS_INDEX_PROPERTY = "documentAuthors";
    protected static final String DOCUMENT_SUMMARY_INDEX_PROPERTY = "documentSummary";
    protected static final String DOCUMENT_KEYWORD_INDEX_PROPERTY = "documentKeyword";
    protected static final String DOCUMENT_NAME_CLOUD_TAG_PROPERTY = "documentCloudTagName";
    protected static final String DOCUMENT_KEYWORD_CLOUD_TAG_PROPERTY = "documentCloudTagKeyword";
    protected static final String DOCUMENT_FILE_CONTENT_INDEX_PROPERTY = "documentFileContent";
    protected static final String DOCUMENT_TYPE = "documentindextype";

    public void indexDocument(DocumentBean document, String fileContent) throws IOException {
        Set keywords;
        Document doc = new Document();
        doc.add((IndexableField)new StringField(DOCUMENT_ID_INDEX_PROPERTY, document.getId(), Field.Store.YES));
        String documentName = document.getName();
        String documentSummary = document.getSummary();
        doc.add((IndexableField)new TextField(DOCUMENT_NAME_INDEX_PROPERTY, documentName, Field.Store.YES));
        if (StringUtils.isNotBlank((CharSequence)document.getAuthors())) {
            doc.add((IndexableField)new TextField(DOCUMENT_AUTHORS_INDEX_PROPERTY, document.getAuthors(), Field.Store.YES));
        }
        doc.add((IndexableField)new Field(DOCUMENT_SUMMARY_INDEX_PROPERTY, documentSummary, LuceneUtils.TYPE_STORED));
        doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
        if (documentName.length() >= 3) {
            doc.add((IndexableField)new Field(DOCUMENT_NAME_CLOUD_TAG_PROPERTY, documentName.replaceAll("'", " "), LuceneUtils.TYPE_STORED));
        }
        if ((keywords = document.getKeywords()) != null) {
            for (String keyword : keywords) {
                doc.add((IndexableField)new Field(DOCUMENT_KEYWORD_INDEX_PROPERTY, keyword, TextField.TYPE_STORED));
                if (keyword.length() < 3) continue;
                doc.add((IndexableField)new Field(DOCUMENT_KEYWORD_CLOUD_TAG_PROPERTY, keyword.replaceAll("'", " "), LuceneUtils.TYPE_STORED));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileContent)) {
            doc.add((IndexableField)new Field(DOCUMENT_FILE_CONTENT_INDEX_PROPERTY, fileContent, LuceneUtils.TYPE_STORED));
        }
        this.getLuceneUtils().getIndexWriter().addDocument((Iterable)doc);
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public List<String> searchDocuments(String text) throws IOException, ParseException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter());
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        String[] words = text.split(" ");
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        BooleanQuery.Builder nameQueryBuilder = new BooleanQuery.Builder();
        BooleanQuery.Builder summaryQueryBuilder = new BooleanQuery.Builder();
        BooleanQuery.Builder authorsQueryBuilder = new BooleanQuery.Builder();
        BooleanQuery.Builder documentFileQueryBuilder = new BooleanQuery.Builder();
        for (String word : words) {
            String wildWord = String.format("*%s*", word.toLowerCase());
            nameQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_NAME_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
            summaryQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_SUMMARY_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
            authorsQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_AUTHORS_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
            documentFileQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_FILE_CONTENT_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
        }
        queryBuilder.add((Query)nameQueryBuilder.build(), BooleanClause.Occur.SHOULD);
        queryBuilder.add((Query)summaryQueryBuilder.build(), BooleanClause.Occur.SHOULD);
        queryBuilder.add((Query)authorsQueryBuilder.build(), BooleanClause.Occur.SHOULD);
        queryBuilder.add((Query)documentFileQueryBuilder.build(), BooleanClause.Occur.SHOULD);
        queryBuilder.add((Query)new TermQuery(new Term(DOCUMENT_KEYWORD_INDEX_PROPERTY, text.toLowerCase())), BooleanClause.Occur.SHOULD);
        BooleanQuery.Builder fullQueryBuilder = new BooleanQuery.Builder();
        fullQueryBuilder.add((Query)queryBuilder.build(), BooleanClause.Occur.MUST);
        fullQueryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)fullQueryBuilder.build(), (int)1000).scoreDocs;
        ArrayList<String> documentIds = new ArrayList<String>(hits.length);
        for (ScoreDoc hit : hits) {
            Document doc = isearcher.doc(hit.doc);
            String documentId = doc.get(DOCUMENT_ID_INDEX_PROPERTY);
            documentIds.add(documentId);
        }
        ireader.close();
        return documentIds;
    }

    public List<String> searchDocuments(List<String> texts) throws IOException, ParseException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter());
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery.Builder keywordsQueryBuilder = new BooleanQuery.Builder();
        for (String text : texts) {
            String[] words = text.split(" ");
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            BooleanQuery.Builder nameQueryBuilder = new BooleanQuery.Builder();
            BooleanQuery.Builder summaryQueryBuilder = new BooleanQuery.Builder();
            BooleanQuery.Builder authorsQueryBuilder = new BooleanQuery.Builder();
            BooleanQuery.Builder documentFileQueryBuilder = new BooleanQuery.Builder();
            for (String word : words) {
                String wildWord = "*" + word.toLowerCase() + "*";
                nameQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_NAME_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
                summaryQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_SUMMARY_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
                authorsQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_AUTHORS_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
                documentFileQueryBuilder.add((Query)new WildcardQuery(new Term(DOCUMENT_FILE_CONTENT_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
            }
            queryBuilder.add((Query)nameQueryBuilder.build(), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)summaryQueryBuilder.build(), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)authorsQueryBuilder.build(), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)documentFileQueryBuilder.build(), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)new TermQuery(new Term(DOCUMENT_KEYWORD_INDEX_PROPERTY, text.toLowerCase())), BooleanClause.Occur.SHOULD);
            keywordsQueryBuilder.add((Query)queryBuilder.build(), BooleanClause.Occur.MUST);
        }
        BooleanQuery.Builder fullQueryBuilder = new BooleanQuery.Builder();
        fullQueryBuilder.add((Query)keywordsQueryBuilder.build(), BooleanClause.Occur.MUST);
        fullQueryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)fullQueryBuilder.build(), (int)1000).scoreDocs;
        ArrayList<String> documentIds = new ArrayList<String>(hits.length);
        for (ScoreDoc hit : hits) {
            Document doc = isearcher.doc(hit.doc);
            String documentId = doc.get(DOCUMENT_ID_INDEX_PROPERTY);
            documentIds.add(documentId);
        }
        ireader.close();
        return documentIds;
    }

    public void updateDocument(DocumentBean document, String fileContent) throws IOException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter());
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)new TermQuery(new Term(DOCUMENT_ID_INDEX_PROPERTY, document.getId())), BooleanClause.Occur.MUST);
        queryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        ScoreDoc[] hits = isearcher.search((Query)queryBuilder.build(), (int)1000).scoreDocs;
        if (hits.length > 0) {
            Set keywords;
            Document doc = new Document();
            doc.add((IndexableField)new StringField(DOCUMENT_ID_INDEX_PROPERTY, document.getId(), Field.Store.YES));
            String documentName = document.getName();
            String documentSummary = document.getSummary();
            doc.add((IndexableField)new TextField(DOCUMENT_NAME_INDEX_PROPERTY, documentName, Field.Store.YES));
            if (StringUtils.isNotBlank((CharSequence)document.getAuthors())) {
                doc.add((IndexableField)new TextField(DOCUMENT_AUTHORS_INDEX_PROPERTY, document.getAuthors(), Field.Store.YES));
            }
            doc.add((IndexableField)new Field(DOCUMENT_SUMMARY_INDEX_PROPERTY, documentSummary, LuceneUtils.TYPE_STORED));
            if (documentName.length() >= 3) {
                doc.add((IndexableField)new Field(DOCUMENT_NAME_CLOUD_TAG_PROPERTY, documentName.replaceAll("'", " "), LuceneUtils.TYPE_STORED));
            }
            if ((keywords = document.getKeywords()) != null) {
                for (String keyword : keywords) {
                    doc.add((IndexableField)new Field(DOCUMENT_KEYWORD_INDEX_PROPERTY, keyword, TextField.TYPE_STORED));
                    if (keyword.length() < 3) continue;
                    doc.add((IndexableField)new Field(DOCUMENT_KEYWORD_CLOUD_TAG_PROPERTY, keyword.replaceAll("'", " "), LuceneUtils.TYPE_STORED));
                }
            }
            doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
            if (StringUtils.isNotBlank((CharSequence)fileContent)) {
                doc.add((IndexableField)new Field(DOCUMENT_FILE_CONTENT_INDEX_PROPERTY, fileContent, LuceneUtils.TYPE_STORED));
            }
            this.getLuceneUtils().getIndexWriter().updateDocument(new Term(DOCUMENT_ID_INDEX_PROPERTY, document.getId()), (Iterable)doc);
            this.getLuceneUtils().getIndexWriter().commit();
        }
        ireader.close();
    }

    public void deleteDocument(String documentId) throws IOException {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)new TermQuery(new Term(DOCUMENT_ID_INDEX_PROPERTY, documentId)), BooleanClause.Occur.MUST);
        queryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{queryBuilder.build()});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public void cleanIndex() throws IOException {
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("type", "document")), BooleanClause.Occur.SHOULD).build();
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public Map<String, Long> getTopDocumentsTerms(List<String> documentIds) throws IOException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter());
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        BooleanQuery.Builder questionIdBuilder = new BooleanQuery.Builder();
        for (String documentId : documentIds) {
            if (!StringUtils.isNotBlank((CharSequence)documentId)) continue;
            questionIdBuilder.add((Query)new TermQuery(new Term(DOCUMENT_ID_INDEX_PROPERTY, documentId.toLowerCase())), BooleanClause.Occur.SHOULD);
        }
        queryBuilder.add((Query)questionIdBuilder.build(), BooleanClause.Occur.MUST);
        TopDocs hits = isearcher.search((Query)queryBuilder.build(), 100);
        ScoreDoc[] scoreDocs = hits.scoreDocs;
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (ScoreDoc scoreDoc : scoreDocs) {
            Fields termVectors = ireader.getTermVectors(scoreDoc.doc);
            if (termVectors == null) continue;
            for (String termVector : termVectors) {
                Terms vector = ireader.getTermVector(scoreDoc.doc, termVector);
                TermsEnum termsEnum = vector.iterator();
                BytesRef bytesRef = termsEnum.next();
                while (bytesRef != null) {
                    String term = bytesRef.utf8ToString().toLowerCase();
                    long totalTermFreq = termsEnum.totalTermFreq();
                    if (CloudWordUtils.isCloudableTerm((String)term)) {
                        if (result.containsKey(term)) {
                            result.put(term, (Long)result.get(term) + totalTermFreq);
                        } else {
                            result.put(term, totalTermFreq);
                        }
                    }
                    bytesRef = termsEnum.next();
                }
            }
        }
        ireader.close();
        return result;
    }
}

