/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.reflection;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.ConversionException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.MarshallingContext;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.reflection.ReflectionProviderWrapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.CGLIBMapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;

public class CGLIBEnhancedConverter
extends SerializableConverter {
    private static String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";
    private static String CALLBACK_MARKER = "CGLIB$CALLBACK_";
    private transient Map fieldCache = new HashMap();

    public CGLIBEnhancedConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, new CGLIBFilteringReflectionProvider(reflectionProvider));
    }

    public boolean canConvert(Class type) {
        return Enhancer.isEnhanced((Class)type) && type.getName().indexOf(DEFAULT_NAMING_MARKER) > 0 || type == CGLIBMapper.Marker.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Callback[] callbacks;
        Class<?> type = source.getClass();
        boolean hasFactory = Factory.class.isAssignableFrom(type);
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, "type", type);
        context.convertAnother(type.getSuperclass());
        writer.endNode();
        writer.startNode("interfaces");
        Class<?>[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] == Factory.class) continue;
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, this.mapper.serializedClass(interfaces[i].getClass()), interfaces[i].getClass());
            context.convertAnother(interfaces[i]);
            writer.endNode();
        }
        writer.endNode();
        writer.startNode("hasFactory");
        writer.setValue(String.valueOf(hasFactory && type.getSuperclass() != Object.class));
        writer.endNode();
        Callback[] callbackArray = callbacks = hasFactory ? ((Factory)source).getCallbacks() : this.getCallbacks(source);
        if (callbacks.length > 1) {
            throw new ConversionException("Cannot handle CGLIB enhanced proxies with multiple callbacks");
        }
        boolean isInterceptor = MethodInterceptor.class.isAssignableFrom(callbacks[0].getClass());
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, this.mapper.serializedClass(callbacks[0].getClass()), callbacks[0].getClass());
        context.convertAnother(callbacks[0]);
        writer.endNode();
        try {
            Field field = type.getDeclaredField("serialVersionUID");
            field.setAccessible(true);
            long serialVersionUID = field.getLong(null);
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, "serialVersionUID", String.class);
            writer.setValue(String.valueOf(serialVersionUID));
            writer.endNode();
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        if (isInterceptor && type.getSuperclass() != Object.class) {
            writer.startNode("instance");
            super.doMarshalConditionally(source, writer, context);
            writer.endNode();
        }
    }

    private Callback[] getCallbacks(Object source) {
        Class<?> type = source.getClass();
        ArrayList<Field> fields = (ArrayList<Field>)this.fieldCache.get(type.getName());
        if (fields == null) {
            fields = new ArrayList<Field>();
            this.fieldCache.put(type.getName(), fields);
            int i = 0;
            while (true) {
                try {
                    Field field = type.getDeclaredField(CALLBACK_MARKER + i);
                    field.setAccessible(true);
                    fields.add(field);
                }
                catch (NoSuchFieldException e) {
                    break;
                }
                ++i;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < fields.size(); ++i) {
            try {
                Field field = (Field)fields.get(i);
                list.add(field.get(source));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Access to " + type.getName() + "." + CALLBACK_MARKER + i + " not allowed");
            }
        }
        return list.toArray(new Callback[list.size()]);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Enhancer enhancer = new Enhancer();
        reader.moveDown();
        enhancer.setSuperclass((Class)context.convertAnother(null, Class.class));
        reader.moveUp();
        reader.moveDown();
        ArrayList<Object> interfaces = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            interfaces.add(context.convertAnother(null, this.mapper.realClass(reader.getNodeName())));
            reader.moveUp();
        }
        enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
        reader.moveUp();
        reader.moveDown();
        enhancer.setUseFactory(Boolean.getBoolean(reader.getValue()));
        reader.moveUp();
        reader.moveDown();
        enhancer.setCallback((Callback)context.convertAnother(null, this.mapper.realClass(reader.getNodeName())));
        reader.moveUp();
        Object result = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("serialVersionUID")) {
                enhancer.setSerialVersionUID(Long.valueOf(reader.getValue()));
            } else if (reader.getNodeName().equals("instance")) {
                result = enhancer.create();
                super.doUnmarshalConditionally(result, reader, context);
            }
            reader.moveUp();
        }
        return this.serializationMethodInvoker.callReadResolve(result == null ? enhancer.create() : result);
    }

    protected List hierarchyFor(Class type) {
        List typeHierarchy = super.hierarchyFor(type);
        typeHierarchy.remove(typeHierarchy.size() - 1);
        return typeHierarchy;
    }

    private Object readResolve() {
        this.fieldCache = new HashMap();
        return this;
    }

    private static class CGLIBFilteringReflectionProvider
    extends ReflectionProviderWrapper {
        public CGLIBFilteringReflectionProvider(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        public void visitSerializableFields(Object object, final ReflectionProvider.Visitor visitor) {
            this.wrapped.visitSerializableFields(object, new ReflectionProvider.Visitor(){

                public void visit(String name, Class type, Class definedIn, Object value) {
                    if (!name.startsWith("CGLIB$")) {
                        visitor.visit(name, type, definedIn, value);
                    }
                }
            });
        }
    }
}

