/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.ssl;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.ConnectTimeoutException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.params.HttpConnectionParams;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;

public class EasySslSocketFactory
implements SecureProtocolSocketFactory {
    private static SSLSocketFactory getEasySSLSocketFactory() {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance((String)"SSL");
            context.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return context.getSocketFactory();
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        Socket socket = EasySslSocketFactory.getEasySSLSocketFactory().createSocket(host, port, clientHost, clientPort);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return EasySslSocketFactory.getEasySSLSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return EasySslSocketFactory.getEasySSLSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort, HttpConnectionParams arg4) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket socket = EasySslSocketFactory.getEasySSLSocketFactory().createSocket(host, port, clientHost, clientPort);
        return socket;
    }

    public static class EasyX509TrustManager
    implements X509TrustManager {
        private X509TrustManager standardTrustManager = null;

        public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory factory = TrustManagerFactory.getInstance((String)"SunX509");
            factory.init(keystore);
            TrustManager[] trustmanagers = factory.getTrustManagers();
            if (trustmanagers.length == 0) {
                throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
            }
            this.standardTrustManager = (X509TrustManager)trustmanagers[0];
        }

        public boolean isClientTrusted(X509Certificate[] certificates) {
            return this.standardTrustManager.isClientTrusted(certificates);
        }

        public boolean isServerTrusted(X509Certificate[] certificates) {
            if (certificates != null && certificates.length == 1) {
                X509Certificate certificate = certificates[0];
                try {
                    certificate.checkValidity();
                }
                catch (CertificateException e) {
                    return false;
                }
                return true;
            }
            return this.standardTrustManager.isServerTrusted(certificates);
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.standardTrustManager.getAcceptedIssuers();
        }
    }
}

