/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignAttributesResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeAssignLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeAssignValue;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsMembershipAnyLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsMembershipLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignAttributesRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAssignAttributes {
    private Timestamp assignmentDisabledTime;
    private Timestamp assignmentEnabledTime;
    private String assignmentNotes;
    private String attributeAssignOperation;
    private String attributeAssignValueOperation;
    private String delegatable;
    private List<WsAttributeAssignValue> values = new ArrayList<WsAttributeAssignValue>();
    private Set<WsAttributeAssignLookup> ownerAttributeAssignLookups = new LinkedHashSet<WsAttributeAssignLookup>();
    private Set<WsSubjectLookup> ownerSubjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private String clientVersion;
    private String attributeAssignType;
    private Set<String> actions = new LinkedHashSet<String>();
    private Set<String> ownerGroupNames = new LinkedHashSet<String>();
    private Set<String> ownerGroupUuids = new LinkedHashSet<String>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> ownerStemNames = new LinkedHashSet<String>();
    private Set<String> ownerStemUuids = new LinkedHashSet<String>();
    private Set<String> ownerAttributeDefNames = new LinkedHashSet<String>();
    private Set<String> ownerAttributeDefUuids = new LinkedHashSet<String>();
    private Set<WsMembershipAnyLookup> ownerMembershipAnyLookups = new LinkedHashSet<WsMembershipAnyLookup>();
    private Set<WsMembershipLookup> ownerMembershipLookups = new LinkedHashSet<WsMembershipLookup>();
    private Set<WsAttributeAssignLookup> attributeAssignLookups = new LinkedHashSet<WsAttributeAssignLookup>();
    private Set<String> attributeDefNameNames = new LinkedHashSet<String>();
    private Set<String> attributeDefNameUuids = new LinkedHashSet<String>();
    private Set<String> attributeDefNamesToReplace = new LinkedHashSet<String>();
    private Set<String> attributeDefUuidsToReplace = new LinkedHashSet<String>();
    private Set<String> actionsToReplace = new LinkedHashSet<String>();
    private Set<String> attributeDefTypesToReplace = new LinkedHashSet<String>();

    public GcAssignAttributes assignAttributeAssignType(String theAttributeAssignType) {
        this.attributeAssignType = theAttributeAssignType;
        return this;
    }

    public GcAssignAttributes addAction(String action) {
        this.actions.add(action);
        return this;
    }

    public GcAssignAttributes assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAssignAttributes addOwnerGroupName(String theGroupName) {
        this.ownerGroupNames.add(theGroupName);
        return this;
    }

    public GcAssignAttributes addOwnerSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.ownerSubjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcAssignAttributes addOwnerGroupUuid(String theGroupUuid) {
        this.ownerGroupUuids.add(theGroupUuid);
        return this;
    }

    public GcAssignAttributes addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignAttributes addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignAttributes assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.attributeAssignType)) {
            throw new RuntimeException("attributeAssignType is required: " + this);
        }
    }

    public GcAssignAttributes addOwnerMembershipAnyLookup(WsMembershipAnyLookup wsMembershipAnyLookup) {
        this.ownerMembershipAnyLookups.add(wsMembershipAnyLookup);
        return this;
    }

    public GcAssignAttributes addOwnerMembershipId(String membershipId) {
        WsMembershipLookup wsMembershipLookup = new WsMembershipLookup();
        wsMembershipLookup.setUuid(membershipId);
        this.ownerMembershipLookups.add(wsMembershipLookup);
        return this;
    }

    public GcAssignAttributes addAttributeAssignId(String attributeAssignId) {
        WsAttributeAssignLookup wsAttributeAssignLookup = new WsAttributeAssignLookup();
        wsAttributeAssignLookup.setUuid(attributeAssignId);
        this.attributeAssignLookups.add(wsAttributeAssignLookup);
        return this;
    }

    public GcAssignAttributes addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcAssignAttributes assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcAssignAttributes assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsAssignAttributesResults execute() {
        this.validate();
        WsAssignAttributesResults wsAssignAttributesResults = null;
        try {
            WsRestAssignAttributesRequest assignAttributes = new WsRestAssignAttributesRequest();
            assignAttributes.setActAsSubjectLookup(this.actAsSubject);
            ArrayList<WsAttributeDefNameLookup> attributeDefNameLookups = new ArrayList<WsAttributeDefNameLookup>();
            for (String attributeDefNameName : this.attributeDefNameNames) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(attributeDefNameName, null));
            }
            for (String attributeDefNameUuid : this.attributeDefNameUuids) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(null, attributeDefNameUuid));
            }
            if (GrouperClientUtils.length(attributeDefNameLookups) > 0) {
                assignAttributes.setWsAttributeDefNameLookups(GrouperClientUtils.toArray(attributeDefNameLookups, WsAttributeDefNameLookup.class));
            }
            ArrayList<WsGroupLookup> ownerGroupLookups = new ArrayList<WsGroupLookup>();
            for (String ownerGroupName : this.ownerGroupNames) {
                ownerGroupLookups.add(new WsGroupLookup(ownerGroupName, null));
            }
            for (String ownerGroupUuid : this.ownerGroupUuids) {
                ownerGroupLookups.add(new WsGroupLookup(null, ownerGroupUuid));
            }
            if (GrouperClientUtils.length(ownerGroupLookups) > 0) {
                assignAttributes.setWsOwnerGroupLookups(GrouperClientUtils.toArray(ownerGroupLookups, WsGroupLookup.class));
            }
            ArrayList<WsStemLookup> ownerStemLookups = new ArrayList<WsStemLookup>();
            for (String ownerStemName : this.ownerStemNames) {
                ownerStemLookups.add(new WsStemLookup(ownerStemName, null));
            }
            for (String ownerStemUuid : this.ownerStemUuids) {
                ownerStemLookups.add(new WsStemLookup(null, ownerStemUuid));
            }
            if (GrouperClientUtils.length(ownerStemLookups) > 0) {
                assignAttributes.setWsOwnerStemLookups(GrouperClientUtils.toArray(ownerStemLookups, WsStemLookup.class));
            }
            if (GrouperClientUtils.length(this.ownerSubjectLookups) > 0) {
                assignAttributes.setWsOwnerSubjectLookups(GrouperClientUtils.toArray(this.ownerSubjectLookups, WsSubjectLookup.class));
            }
            if (GrouperClientUtils.length(this.ownerMembershipAnyLookups) > 0) {
                assignAttributes.setWsOwnerMembershipAnyLookups(GrouperClientUtils.toArray(this.ownerMembershipAnyLookups, WsMembershipAnyLookup.class));
            }
            if (GrouperClientUtils.length(this.ownerMembershipLookups) > 0) {
                assignAttributes.setWsOwnerMembershipLookups(GrouperClientUtils.toArray(this.ownerMembershipLookups, WsMembershipLookup.class));
            }
            ArrayList<WsAttributeDefLookup> ownerAttributeDefLookups = new ArrayList<WsAttributeDefLookup>();
            for (String ownerAttributeDefName : this.ownerAttributeDefNames) {
                ownerAttributeDefLookups.add(new WsAttributeDefLookup(ownerAttributeDefName, null));
            }
            for (String ownerAttributeDefUuid : this.ownerAttributeDefUuids) {
                ownerAttributeDefLookups.add(new WsAttributeDefLookup(null, ownerAttributeDefUuid));
            }
            if (GrouperClientUtils.length(ownerAttributeDefLookups) > 0) {
                assignAttributes.setWsOwnerAttributeDefLookups(GrouperClientUtils.toArray(ownerAttributeDefLookups, WsAttributeDefLookup.class));
            }
            if (GrouperClientUtils.length(this.values) > 0) {
                assignAttributes.setValues(GrouperClientUtils.toArray(this.values, WsAttributeAssignValue.class));
            }
            if (GrouperClientUtils.length(this.ownerAttributeAssignLookups) > 0) {
                assignAttributes.setWsOwnerAttributeAssignLookups(GrouperClientUtils.toArray(this.ownerAttributeAssignLookups, WsAttributeAssignLookup.class));
            }
            if (GrouperClientUtils.length(this.actionsToReplace) > 0) {
                assignAttributes.setActionsToReplace(GrouperClientUtils.toArray(this.actionsToReplace, String.class));
            }
            if (GrouperClientUtils.length(this.attributeDefTypesToReplace) > 0) {
                assignAttributes.setAttributeDefTypesToReplace(GrouperClientUtils.toArray(this.attributeDefTypesToReplace, String.class));
            }
            ArrayList<WsAttributeDefLookup> attributeDefLookupsToReplace = new ArrayList<WsAttributeDefLookup>();
            for (String attributeDefNameToReplace : this.attributeDefNamesToReplace) {
                attributeDefLookupsToReplace.add(new WsAttributeDefLookup(attributeDefNameToReplace, null));
            }
            for (String attributeDefUuidToReplace : this.attributeDefUuidsToReplace) {
                attributeDefLookupsToReplace.add(new WsAttributeDefLookup(null, attributeDefUuidToReplace));
            }
            if (GrouperClientUtils.length(attributeDefLookupsToReplace) > 0) {
                assignAttributes.setAttributeDefsToReplace(GrouperClientUtils.toArray(attributeDefLookupsToReplace, WsAttributeDefLookup.class));
            }
            if (this.includeGroupDetail != null) {
                assignAttributes.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                assignAttributes.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.assignmentDisabledTime != null) {
                String disabledTime = GrouperClientUtils.dateToString(this.assignmentDisabledTime);
                assignAttributes.setAssignmentDisabledTime(disabledTime);
            }
            if (this.assignmentEnabledTime != null) {
                String enabledTime = GrouperClientUtils.dateToString(this.assignmentEnabledTime);
                assignAttributes.setAssignmentEnabledTime(enabledTime);
            }
            assignAttributes.setAssignmentNotes(this.assignmentNotes);
            assignAttributes.setAttributeAssignOperation(this.attributeAssignOperation);
            assignAttributes.setAttributeAssignValueOperation(this.attributeAssignValueOperation);
            assignAttributes.setDelegatable(this.delegatable);
            if (GrouperClientUtils.length(this.attributeAssignLookups) > 0) {
                assignAttributes.setWsAttributeAssignLookups(GrouperClientUtils.toArray(this.attributeAssignLookups, WsAttributeAssignLookup.class));
            }
            assignAttributes.setAttributeAssignType(this.attributeAssignType);
            if (this.params.size() > 0) {
                assignAttributes.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (this.subjectAttributeNames.size() > 0) {
                assignAttributes.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (GrouperClientUtils.length(this.actions) > 0) {
                assignAttributes.setActions(GrouperClientUtils.toArray(this.actions, String.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAssignAttributesResults = (WsAssignAttributesResults)grouperClientWs.executeService("attributeAssignments", assignAttributes, "getAttributeAssignments", this.clientVersion);
            String resultMessage = wsAssignAttributesResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAssignAttributesResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAssignAttributesResults;
    }

    public GcAssignAttributes addOwnerStemName(String theStemName) {
        this.ownerStemNames.add(theStemName);
        return this;
    }

    public GcAssignAttributes addOwnerStemUuid(String theStemUuid) {
        this.ownerStemUuids.add(theStemUuid);
        return this;
    }

    public GcAssignAttributes addOwnerAttributeDefName(String theAttributeDefName) {
        this.ownerAttributeDefNames.add(theAttributeDefName);
        return this;
    }

    public GcAssignAttributes addOwnerAttributeDefUuid(String theAttributeDefUuid) {
        this.ownerAttributeDefUuids.add(theAttributeDefUuid);
        return this;
    }

    public GcAssignAttributes addAttributeDefNameName(String theAttributeDefNameName) {
        this.attributeDefNameNames.add(theAttributeDefNameName);
        return this;
    }

    public GcAssignAttributes addAttributeDefNameUuid(String theAttributeDefNameUuid) {
        this.attributeDefNameUuids.add(theAttributeDefNameUuid);
        return this;
    }

    public GcAssignAttributes assignDisabledTime(Timestamp theDisabledTime) {
        this.assignmentDisabledTime = theDisabledTime;
        return this;
    }

    public GcAssignAttributes assignEnabledTime(Timestamp theEnabledTime) {
        this.assignmentEnabledTime = theEnabledTime;
        return this;
    }

    public GcAssignAttributes assignAssignmentNotes(String theAssignmentNotes) {
        this.assignmentNotes = theAssignmentNotes;
        return this;
    }

    public GcAssignAttributes assignAttributeAssignOperation(String theAttributeAssignOperation) {
        this.attributeAssignOperation = theAttributeAssignOperation;
        return this;
    }

    public GcAssignAttributes assignAttributeAssignValueOperation(String theAttributeAssignValueOperation) {
        this.attributeAssignValueOperation = theAttributeAssignValueOperation;
        return this;
    }

    public GcAssignAttributes assignDelegatable(String theDelegatable) {
        this.delegatable = theDelegatable;
        return this;
    }

    public GcAssignAttributes addValue(WsAttributeAssignValue wsAttributeAssignValue) {
        this.values.add(wsAttributeAssignValue);
        return this;
    }

    public GcAssignAttributes addOwnerAttributeAssignLookup(WsAttributeAssignLookup wsAttributeAssignLookup) {
        this.ownerAttributeAssignLookups.add(wsAttributeAssignLookup);
        return this;
    }

    public GcAssignAttributes addAttributeDefNameToReplace(String theAttributeDefName) {
        this.attributeDefNamesToReplace.add(theAttributeDefName);
        return this;
    }

    public GcAssignAttributes addAttributeDefUuidToReplace(String theAttributeDefUuid) {
        this.attributeDefUuidsToReplace.add(theAttributeDefUuid);
        return this;
    }

    public GcAssignAttributes addActionToReplace(String action) {
        this.actionsToReplace.add(action);
        return this;
    }

    public GcAssignAttributes addAttributeDefTypeToReplace(String attributeDefTypeToReplace) {
        this.attributeDefTypesToReplace.add(attributeDefTypeToReplace);
        return this;
    }
}

