/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap;

import org.nustaq.logging.FSTLogger;
import org.nustaq.offheap.bytez.ByteSink;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.onheap.HeapBytez;

public class BinaryQueue {
    private static final FSTLogger logger = FSTLogger.getLogger(BinaryQueue.class);
    Bytez storage;
    long addIndex = 0L;
    long pollIndex = 0L;

    public BinaryQueue() {
        this(1024);
    }

    public BinaryQueue(int qsize) {
        this.storage = new HeapBytez(qsize);
    }

    public void add(ByteSource source) {
        this.add(source, 0L, source.length());
    }

    public void add(ByteSource source, long sourceoff, long sourcelen) {
        if (sourcelen >= this.remaining()) {
            this.grow(sourcelen + 1L);
            this.add(source, sourceoff, sourcelen);
            return;
        }
        int i = 0;
        while ((long)i < sourcelen) {
            this.storage.put(this.addIndex++, source.get((long)i + sourceoff));
            if (this.addIndex >= this.storage.length()) {
                this.addIndex -= this.storage.length();
            }
            ++i;
        }
    }

    public void addInt(int written) {
        this.add((byte)(written >>> 0 & 0xFF));
        this.add((byte)(written >>> 8 & 0xFF));
        this.add((byte)(written >>> 16 & 0xFF));
        this.add((byte)(written >>> 24 & 0xFF));
    }

    public void add(byte b) {
        long remaining = this.remaining();
        if (1L >= remaining) {
            this.grow(2L);
            this.add(b);
            return;
        }
        this.storage.put(this.addIndex++, b);
        if (this.addIndex >= this.storage.length()) {
            this.addIndex -= this.storage.length();
        }
    }

    protected void grow(long sourcelen) {
        HeapBytez newStorage = new HeapBytez((int)Math.max(this.capacity() * 2L, this.capacity() + sourcelen + this.available()));
        long len = this.poll(newStorage, 0L, this.available());
        this.pollIndex = 0L;
        this.addIndex = len;
        this.storage = newStorage;
    }

    public long remaining() {
        return this.capacity() - this.available();
    }

    public long poll(ByteSink destination, long destoff, long destlen) {
        long count = 0L;
        try {
            while (this.pollIndex != this.addIndex && count < destlen) {
                destination.put(destoff + count++, this.storage.get(this.pollIndex++));
                if (this.pollIndex < this.storage.length()) continue;
                this.pollIndex = 0L;
            }
        }
        catch (Exception e) {
            logger.log(FSTLogger.Level.ERROR, "Failed to poll", e);
        }
        return count;
    }

    public byte[] readByteArray(int len) {
        if (this.available() < (long)len) {
            throw new RuntimeException("not enough data available, check available() > len before calling");
        }
        byte[] b = new byte[len];
        int count = 0;
        while (this.pollIndex != this.addIndex && count < len) {
            b[count++] = this.storage.get(this.pollIndex++);
            if (this.pollIndex < this.storage.length()) continue;
            this.pollIndex = 0L;
        }
        return b;
    }

    public int readInt() {
        if (this.available() < 4L) {
            throw new RuntimeException("not enough data available, check available() > 4 before calling");
        }
        int ch1 = this.poll();
        int ch2 = this.poll();
        int ch3 = this.poll();
        int ch4 = this.poll();
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public int poll() {
        int result = -1;
        if (this.pollIndex != this.addIndex) {
            result = this.storage.get(this.pollIndex++) + 256 & 0xFF;
            if (this.pollIndex >= this.storage.length()) {
                this.pollIndex = 0L;
            }
        }
        return result;
    }

    public void back(int len) {
        this.pollIndex = this.pollIndex >= (long)len ? (this.pollIndex -= (long)len) : this.pollIndex + this.capacity() - (long)len;
    }

    public long available() {
        return this.addIndex >= this.pollIndex ? this.addIndex - this.pollIndex : this.addIndex + this.capacity() - this.pollIndex;
    }

    public long capacity() {
        return this.storage.length();
    }

    public String toString() {
        return "BinaryQueue{storage=" + this.storage + ", addIndex=" + this.addIndex + ", pollIndex=" + this.pollIndex + "}";
    }
}

