/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate4;

import com.pyx4j.log4j.MavenLogAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;
import org.scannotation.AnnotationDB;

public class Hbm2DdlMojo
extends AbstractMojo {
    public static final String EXPORT_SKIPPED_PROPERTY = "hibernate.export.skipped";
    public static final String DRIVER_CLASS = "hibernate.connection.driver_class";
    public static final String URL = "hibernate.connection.url";
    public static final String USERNAME = "hibernate.connection.username";
    public static final String PASSWORD = "hibernate.connection.password";
    public static final String DIALECT = "hibernate.dialect";
    private static final String MD5S = "schema.md5s";
    private MavenProject project;
    private String buildDirectory;
    private String outputDirectory;
    private boolean scanTestClasses;
    private String testOutputDirectory;
    private boolean skip;
    private boolean force;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String hibernateDialect;
    private String hibernateProperties;
    private String target;
    private String type;
    private String outputFile;
    private String delimiter;
    private boolean format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        SchemaExport.Type type;
        HashMap md5s;
        if (this.skip) {
            this.getLog().info((CharSequence)"Exectuion of hibernate4-maven-plugin:export was skipped!");
            this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
            return;
        }
        File dir = new File(this.outputDirectory);
        if (!dir.exists()) {
            throw new MojoExecutionException("Cannot scan for annotated classes in " + this.outputDirectory + ": directory does not exist!");
        }
        boolean modified = false;
        File saved = new File(this.buildDirectory + File.separator + MD5S);
        if (saved.exists()) {
            try {
                FileInputStream fis = new FileInputStream(saved);
                ObjectInputStream ois = new ObjectInputStream(fis);
                md5s = (HashMap)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                md5s = new HashMap();
                this.getLog().warn((CharSequence)("Cannot read timestamps from saved: " + e));
            }
        } else {
            md5s = new HashMap();
            try {
                saved.createNewFile();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Cannot create saved for timestamps: " + e));
            }
        }
        URLClassLoader classLoader = null;
        try {
            void var8_14;
            this.getLog().debug((CharSequence)"Creating ClassLoader for project-dependencies...");
            List classpathFiles = this.project.getCompileClasspathElements();
            if (this.scanTestClasses) {
                classpathFiles.addAll(this.project.getTestClasspathElements());
            }
            URL[] urls = new URL[classpathFiles.size()];
            boolean bl = false;
            while (var8_14 < classpathFiles.size()) {
                this.getLog().debug((CharSequence)("Dependency: " + (String)classpathFiles.get((int)var8_14)));
                urls[var8_14] = new File((String)classpathFiles.get((int)var8_14)).toURI().toURL();
                ++var8_14;
            }
            classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while creating ClassLoader!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        TreeSet classes = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> a, Class<?> b) {
                return a.getName().compareTo(b.getName());
            }
        });
        try {
            AnnotationDB db = new AnnotationDB();
            this.getLog().info((CharSequence)("Scanning directory " + this.outputDirectory + " for annotated classes..."));
            URL uRL = dir.toURI().toURL();
            db.scanArchives(new URL[]{uRL});
            if (this.scanTestClasses) {
                dir = new File(this.testOutputDirectory);
                if (!dir.exists()) {
                    throw new MojoExecutionException("Cannot scan for annotated test-classes in " + this.testOutputDirectory + ": directory does not exist!");
                }
                this.getLog().info((CharSequence)("Scanning directory " + this.testOutputDirectory + " for annotated classes..."));
                URL uRL2 = dir.toURI().toURL();
                db.scanArchives(new URL[]{uRL2});
            }
            HashSet classNames = new HashSet();
            if (db.getAnnotationIndex().containsKey(Entity.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(Entity.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(MappedSuperclass.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(MappedSuperclass.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(Embeddable.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(Embeddable.class.getName()));
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (String string : classNames) {
                String oldMd5;
                int i;
                Class<?> annotatedClass = classLoader.loadClass(string);
                classes.add(annotatedClass);
                InputStream is = annotatedClass.getResourceAsStream(annotatedClass.getSimpleName() + ".class");
                byte[] buffer = new byte[4096];
                while ((i = is.read(buffer)) > -1) {
                    messageDigest.update(buffer, 0, i);
                }
                is.close();
                byte[] bytes = messageDigest.digest();
                BigInteger bi = new BigInteger(1, bytes);
                String newMd5 = String.format("%0" + (bytes.length << 1) + "x", bi);
                String string2 = oldMd5 = !md5s.containsKey(string) ? "" : (String)md5s.get(string);
                if (!newMd5.equals(oldMd5)) {
                    this.getLog().debug((CharSequence)("Found new or modified annotated class: " + string));
                    modified = true;
                    md5s.put(string, newMd5);
                    continue;
                }
                this.getLog().debug((CharSequence)(oldMd5 + " -> class unchanged: " + string));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"Error while adding annotated classes!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while scanning!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
        if (classes.isEmpty()) {
            throw new MojoFailureException("No annotated classes found in directory " + this.outputDirectory);
        }
        this.getLog().debug((CharSequence)"Detected classes with mapping-annotations:");
        for (Class clazz : classes) {
            this.getLog().debug((CharSequence)("  " + clazz.getName()));
        }
        Properties properties = new Properties();
        try {
            File file = new File(this.hibernateProperties);
            if (file.exists()) {
                this.getLog().info((CharSequence)("Reading properties from file " + this.hibernateProperties + "..."));
                properties.load(new FileInputStream(file));
            } else {
                this.getLog().info((CharSequence)("No hibernate-properties-file found! (Checked path: " + this.hibernateProperties + ")"));
            }
        }
        catch (IOException iOException) {
            this.getLog().error((CharSequence)"Error while reading properties!", (Throwable)iOException);
            throw new MojoExecutionException(iOException.getMessage());
        }
        if (this.driverClassName != null) {
            if (properties.containsKey(DRIVER_CLASS)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.driver_class=" + properties.getProperty(DRIVER_CLASS) + " with the value " + this.driverClassName));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.driverClassName));
            }
            properties.setProperty(DRIVER_CLASS, this.driverClassName);
        }
        if (this.url != null) {
            if (properties.containsKey(URL)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.url=" + properties.getProperty(URL) + " with the value " + this.url));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.url));
            }
            properties.setProperty(URL, this.url);
        }
        if (this.username != null) {
            if (properties.containsKey(USERNAME)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.username=" + properties.getProperty(USERNAME) + " with the value " + this.username));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.username));
            }
            properties.setProperty(USERNAME, this.username);
        }
        if (this.password != null) {
            if (properties.containsKey(PASSWORD)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.password=" + properties.getProperty(PASSWORD) + " with the value " + this.password));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.password));
            }
            properties.setProperty(PASSWORD, this.password);
        }
        if (this.hibernateDialect != null) {
            if (properties.containsKey(DIALECT)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.dialect=" + properties.getProperty(DIALECT) + " with the value " + this.hibernateDialect));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.hibernateDialect));
            }
            properties.setProperty(DIALECT, this.hibernateDialect);
        }
        if (md5s.containsKey(DIALECT)) {
            String string = properties.getProperty(DIALECT);
            if (((String)md5s.get(DIALECT)).equals(string)) {
                this.getLog().debug((CharSequence)"SQL-dialect unchanged.");
            } else {
                this.getLog().debug((CharSequence)("SQL-dialect changed: " + string));
                modified = true;
                md5s.put(DIALECT, string);
            }
        } else {
            modified = true;
            md5s.put(DIALECT, properties.getProperty(DIALECT));
        }
        if (properties.isEmpty()) {
            this.getLog().error((CharSequence)"No properties set!");
            throw new MojoFailureException("Hibernate-Configuration is missing!");
        }
        Configuration configuration = new Configuration();
        configuration.setProperties(properties);
        this.getLog().debug((CharSequence)"Adding annotated classes to hibernate-mapping-configuration...");
        for (Class clazz : classes) {
            this.getLog().debug((CharSequence)("Class " + clazz));
            configuration.addAnnotatedClass(clazz);
        }
        Target target = null;
        try {
            target = Target.valueOf((String)this.target.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getLog().error((CharSequence)("Invalid value for configuration-option \"target\": " + this.target));
            this.getLog().error((CharSequence)"Valid values are: NONE, SCRIPT, EXPORT, BOTH");
            throw new MojoExecutionException("Invalid value for configuration-option \"target\"");
        }
        Object var10_30 = null;
        try {
            type = SchemaExport.Type.valueOf((String)this.type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLog().error((CharSequence)("Invalid value for configuration-option \"type\": " + this.type));
            this.getLog().error((CharSequence)"Valid values are: NONE, CREATE, DROP, BOTH");
            throw new MojoExecutionException("Invalid value for configuration-option \"type\"");
        }
        if (target.equals((Object)Target.SCRIPT) || target.equals((Object)Target.NONE)) {
            this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
        }
        if (!(modified || target.equals((Object)Target.SCRIPT) || target.equals((Object)Target.NONE) || this.force)) {
            this.getLog().info((CharSequence)"No modified annotated classes found and dialect unchanged.");
            this.getLog().info((CharSequence)"Skipping schema generation!");
            this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
            return;
        }
        this.getLog().info((CharSequence)"Gathered hibernate-configuration (turn on debugging for details):");
        for (Map.Entry entry : properties.entrySet()) {
            this.getLog().info((CharSequence)("  " + entry.getKey() + " = " + entry.getValue()));
        }
        Connection connection = null;
        try {
            switch (target) {
                case EXPORT: 
                case BOTH: {
                    switch (type) {
                        case CREATE: 
                        case DROP: 
                        case BOTH: {
                            Class<?> clazz = classLoader.loadClass(properties.getProperty(DRIVER_CLASS));
                            this.getLog().debug((CharSequence)("Registering JDBC-driver " + clazz.getName()));
                            DriverManager.registerDriver(new DriverProxy((Driver)clazz.newInstance()));
                            this.getLog().debug((CharSequence)("Opening JDBC-connection to " + properties.getProperty(URL) + " as " + properties.getProperty(USERNAME) + " with password " + properties.getProperty(PASSWORD)));
                            connection = DriverManager.getConnection(properties.getProperty(URL), properties.getProperty(USERNAME), properties.getProperty(PASSWORD));
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getLog().error((CharSequence)("Dependency for driver-class " + properties.getProperty(DRIVER_CLASS) + " is missing!"));
            throw new MojoExecutionException(classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            this.getLog().error((CharSequence)"Cannot establish connection to database!");
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            if (!drivers.hasMoreElements()) {
                this.getLog().error((CharSequence)"No drivers registered!");
            }
            while (drivers.hasMoreElements()) {
                this.getLog().debug((CharSequence)("Driver: " + drivers.nextElement()));
            }
            throw new MojoExecutionException(exception.getMessage());
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            SchemaExport export = new SchemaExport(configuration, connection);
            export.setOutputFile(this.outputFile);
            export.setDelimiter(this.delimiter);
            export.setFormat(this.format);
            export.execute(target, type);
            for (Object exception : export.getExceptions()) {
                this.getLog().debug((CharSequence)exception.toString());
            }
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
            Thread.currentThread().setContextClassLoader(classLoader2);
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.getLog().error((CharSequence)("Error while closing connection: " + e.getMessage()));
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(saved);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(md5s);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Cannot write md5-sums to file: " + e));
        }
    }

    static final class DriverProxy
    implements Driver {
        private final Driver target;

        DriverProxy(Driver target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
        }

        public Driver getTarget() {
            return this.target;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.target.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.target.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.target.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.target.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.target.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.target.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported, for backward-compatibility with Java 1.6");
        }

        public String toString() {
            return "Proxy: " + this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DriverProxy)) {
                return false;
            }
            DriverProxy other = (DriverProxy)obj;
            return this.target.equals(other.target);
        }
    }
}

