/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.prefs.protobuf;

import com.google.protobuf.ByteString;
import de.huxhorn.lilith.prefs.LilithPreferences;
import de.huxhorn.lilith.prefs.protobuf.generated.PrefsProto;
import de.huxhorn.sulky.codec.streaming.StreamingEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LilithPreferencesStreamingEncoder
implements StreamingEncoder<LilithPreferences> {
    public void encode(LilithPreferences obj, OutputStream into) throws IOException {
        PrefsProto.LilithPreferences converted = LilithPreferencesStreamingEncoder.convert(obj);
        if (converted != null) {
            converted.writeTo(into);
        }
    }

    private static PrefsProto.DirectoryContent.Builder convert(Map<String, byte[]> dir) {
        if (dir == null) {
            return null;
        }
        PrefsProto.DirectoryContent.Builder builder = PrefsProto.DirectoryContent.newBuilder();
        for (Map.Entry<String, byte[]> current : dir.entrySet()) {
            builder.addEntry(LilithPreferencesStreamingEncoder.convert(current));
        }
        return builder;
    }

    private static PrefsProto.ByteArrayMapEntry.Builder convert(Map.Entry<String, byte[]> current) {
        PrefsProto.ByteArrayMapEntry.Builder builder = PrefsProto.ByteArrayMapEntry.newBuilder();
        builder.setKey(current.getKey());
        builder.setValue(ByteString.copyFrom((byte[])current.getValue()));
        return builder;
    }

    private static PrefsProto.LilithPreferences convert(LilithPreferences p) {
        if (p == null) {
            return null;
        }
        PrefsProto.LilithPreferences.Builder prefs = PrefsProto.LilithPreferences.newBuilder();
        if (p.getGroovyConditions() != null) {
            prefs.setGroovyConditions(LilithPreferencesStreamingEncoder.convert(p.getGroovyConditions()));
        }
        if (p.getGroovyClipboardFormatters() != null) {
            prefs.setGroovyClipboardFormatters(LilithPreferencesStreamingEncoder.convert(p.getGroovyClipboardFormatters()));
        }
        if (p.getDetailsView() != null) {
            prefs.setDetailsView(LilithPreferencesStreamingEncoder.convert(p.getDetailsView()));
        }
        if (p.getRootFiles() != null) {
            prefs.setRootFiles(LilithPreferencesStreamingEncoder.convert(p.getRootFiles()));
        }
        prefs.setBlacklistName(p.getBlackListName());
        prefs.setWhitelistName(p.getWhiteListName());
        prefs.setLookAndFeel(p.getLookAndFeel());
        prefs.setAskingBeforeQuit(p.isAskingBeforeQuit());
        prefs.setAutoClosing(p.isAutoClosing());
        prefs.setAutoFocusingWindow(p.isAutoFocusingWindow());
        prefs.setAutoOpening(p.isAutoOpening());
        prefs.setCheckingForUpdate(p.isCheckingForUpdate());
        prefs.setCheckingForSnapshot(p.isCheckingForSnapshot());
        prefs.setCleaningLogsOnExit(p.isCleaningLogsOnExit());
        prefs.setColoringWholeRow(p.isColoringWholeRow());
        prefs.setGlobalLoggingEnabled(p.isGlobalLoggingEnabled());
        prefs.setHidingOnClose(p.isHidingOnClose());
        prefs.setLoggingStatisticEnabled(p.isLoggingStatisticEnabled());
        prefs.setMaximizingInternalFrames(p.isMaximizingInternalFrames());
        prefs.setMute(p.isMute());
        prefs.setScrollingToBottom(p.isScrollingToBottom());
        prefs.setShowingFullCallstack(p.isShowingFullCallstack());
        prefs.setShowingFullRecentPath(p.isShowingFullRecentPath());
        prefs.setShowingIdentifier(p.isShowingIdentifier());
        prefs.setShowingStatusbar(p.isShowingStatusbar());
        prefs.setShowingStacktrace(p.isShowingStackTrace());
        prefs.setUsingWrappedExceptionStyle(p.isUsingWrappedExceptionStyle());
        prefs.setShowingTipOfTheDay(p.isShowingTipOfTheDay());
        prefs.setShowingToolbar(p.isShowingToolbar());
        prefs.setSplashScreenDisabled(p.isSplashScreenDisabled());
        prefs.setTrayActive(p.isTrayActive());
        prefs.setUsingInternalFrames(p.isUsingInternalFrames());
        prefs.setDefaultConditionName(p.getDefaultConditionName());
        LilithPreferences.SourceFiltering sf = p.getSourceFiltering();
        if (sf != null) {
            switch (sf) {
                case BLACKLIST: {
                    prefs.setSourceFiltering(PrefsProto.SourceFiltering.BLACKLIST);
                    break;
                }
                case WHITELIST: {
                    prefs.setSourceFiltering(PrefsProto.SourceFiltering.WHITELIST);
                    break;
                }
                default: {
                    prefs.setSourceFiltering(PrefsProto.SourceFiltering.NONE);
                    break;
                }
            }
        } else {
            prefs.setSourceFiltering(PrefsProto.SourceFiltering.NONE);
        }
        return prefs.build();
    }
}

