/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.modules.jaxrs.api.impl.MethodImpl;
import com.webcohesion.enunciate.modules.jaxrs.model.ResourceMethod;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ResourceImpl
implements Resource {
    final ResourceMethod resourceMethod;
    private final ResourceGroup group;
    private final List<Method> methods;
    private final ApiRegistrationContext registrationContext;

    public ResourceImpl(ResourceMethod resourceMethod, ResourceGroup group, ApiRegistrationContext registrationContext) {
        this.resourceMethod = resourceMethod;
        this.group = group;
        Set<String> httpMethods = this.resourceMethod.getHttpMethods();
        this.methods = new ArrayList<Method>(httpMethods.size());
        for (String httpMethod : httpMethods) {
            this.methods.add(new MethodImpl(httpMethod, this.resourceMethod, this.group, registrationContext));
        }
        this.registrationContext = registrationContext;
    }

    public String getPath() {
        return this.resourceMethod.getFullpath();
    }

    public String getRelativePath() {
        String relativePath = this.getPath();
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    public String getSlug() {
        return this.group.getSlug() + "_" + this.resourceMethod.getSimpleName();
    }

    public String getDeprecated() {
        String message = ElementUtils.findDeprecationMessage((DecoratedElement)this.resourceMethod, (JavaDocTagHandler)this.registrationContext.getTagHandler());
        if (message == null) {
            message = ElementUtils.findDeprecationMessage((DecoratedElement)this.resourceMethod.getParent(), (JavaDocTagHandler)this.registrationContext.getTagHandler());
        }
        return message;
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getParent().getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        }
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)((DecoratedElement)this.resourceMethod.getParent().getPackage()).getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        }
        return tags == null ? null : tags.toString();
    }

    public List<String> getSeeAlso() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getParent().getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        }
        if (tags == null) {
            tags = (JavaDoc.JavaDocTagList)((DecoratedElement)this.resourceMethod.getParent().getPackage()).getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
        }
        return tags;
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public List<? extends Method> getMethods() {
        return this.methods;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.resourceMethod.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.resourceMethod.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.resourceMethod.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.resourceMethod.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.resourceMethod), (Map)this.resourceMethod.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public ResourceGroup getGroup() {
        return this.group;
    }

    public Element getJavaElement() {
        return this.resourceMethod;
    }
}

