/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.AnnotationValidator;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import com.vaadin.flow.server.startup.RouteRegistryInitializer;
import com.vaadin.flow.server.startup.VaadinAppShellInitializer;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.flow.server.startup.WebComponentConfigurationRegistryInitializer;
import com.vaadin.flow.server.startup.WebComponentExporterAwareValidator;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.spring.PrefixTree;
import com.vaadin.flow.spring.ReloadCache;
import com.vaadin.flow.spring.ReloadEvent;
import com.vaadin.flow.spring.ReloadListener;
import com.vaadin.flow.spring.SpringLookupInitializer;
import com.vaadin.flow.spring.VaadinScanPackagesRegistrar;
import com.vaadin.flow.spring.io.FilterableResourceResolver;
import com.vaadin.flow.theme.Theme;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;

public class VaadinServletContextInitializer
implements ServletContextInitializer {
    private static boolean devModeCachingEnabled;
    private ApplicationContext appContext;
    private ResourceLoader customLoader;
    private static final List<String> DEFAULT_SCAN_NEVER;
    private static final List<String> DEFAULT_SCAN_ONLY;
    private final List<String> customScanOnly;

    protected Set<Class<?>> findClassesForDevMode(Set<String> basePackages, List<Class<? extends Annotation>> annotations, List<Class<?>> superTypes) {
        return this.findByAnnotationOrSuperType(basePackages, this.customLoader, annotations, superTypes).collect(Collectors.toSet());
    }

    public VaadinServletContextInitializer(ApplicationContext context) {
        this.appContext = context;
        String neverScanProperty = this.appContext.getEnvironment().getProperty("vaadin.blocked-packages");
        if (neverScanProperty == null && (neverScanProperty = this.appContext.getEnvironment().getProperty("vaadin.blacklisted-packages")) != null) {
            VaadinServletContextInitializer.getLogger().warn("vaadin.blacklisted-packages is deprecated and may not be supported in the future. Use vaadin.blocked-packages instead.");
        }
        List<String> neverScan = neverScanProperty == null ? Collections.emptyList() : Arrays.stream(neverScanProperty.split(",")).map(pkg -> pkg.replace('.', '/').trim()).collect(Collectors.toList());
        String onlyScanProperty = this.appContext.getEnvironment().getProperty("vaadin.allowed-packages");
        if (onlyScanProperty == null && (onlyScanProperty = this.appContext.getEnvironment().getProperty("vaadin.whitelisted-packages")) != null) {
            VaadinServletContextInitializer.getLogger().warn("vaadin.whitelisted-packages is deprecated and may not be supported in the future. Use vaadin.allowed-packages instead.");
        }
        if (onlyScanProperty == null) {
            this.customScanOnly = Collections.emptyList();
            this.customLoader = new CustomResourceLoader((ResourceLoader)this.appContext, neverScan);
        } else {
            this.customScanOnly = Arrays.stream(onlyScanProperty.split(",")).map(onlyPackage -> onlyPackage.replace('/', '.').trim()).collect(Collectors.toList());
            this.customLoader = new CustomResourceLoader((ResourceLoader)this.appContext);
        }
        if (!this.customScanOnly.isEmpty() && !neverScan.isEmpty()) {
            VaadinServletContextInitializer.getLogger().warn("vaadin.blocked-packages is ignored because both vaadin.allowed-packages and vaadin.blocked-packages have been set.");
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        servletContext.addListener((EventListener)((Object)this.createCompositeListener(vaadinContext)));
    }

    private void initializeDevModeClassCache() {
        try {
            Class.forName("org.springframework.boot.devtools.livereload.LiveReloadServer");
            if (this.appContext instanceof ConfigurableApplicationContext) {
                String devModeCachingProperty = this.appContext.getEnvironment().getProperty("vaadin.devmode-caching");
                if (devModeCachingProperty != null && !"true".equals(devModeCachingProperty)) {
                    VaadinServletContextInitializer.getLogger().debug("Disabling dev mode scanned class caching since vaadin.devmode-caching is set to a non-true value.");
                } else {
                    VaadinServletContextInitializer.getLogger().debug("Spring Boot DevTools found. Enabling scanned class caching.");
                    devModeCachingEnabled = true;
                    ((ConfigurableApplicationContext)this.appContext).addApplicationListener((ApplicationListener)new ReloadListener((SerializableConsumer<ReloadEvent>)(SerializableConsumer & Serializable)e -> {
                        ReloadCache.dynamicWhiteList.addAll(e.getAddedPackages());
                        ReloadCache.dynamicWhiteList.addAll(e.getChangedPackages());
                        ReloadCache.routePackages.addAll(e.getAddedPackages());
                        ReloadCache.routePackages.addAll(e.getChangedPackages());
                    }));
                }
            }
        }
        catch (ClassNotFoundException e2) {
            VaadinServletContextInitializer.getLogger().debug("Spring Boot DevTools not found. Disabling scanned class caching.");
        }
    }

    private CompositeServletContextListener createCompositeListener(VaadinServletContext context) {
        CompositeServletContextListener compositeListener = new CompositeServletContextListener();
        compositeListener.addListener(new LookupInitializerListener());
        compositeListener.addListener(new VaadinAppShellContextListener());
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)context);
        if (registry.getRegisteredRoutes().isEmpty()) {
            compositeListener.addListener(new RouteServletContextListener());
        }
        compositeListener.addListener(new ErrorParameterServletContextListener());
        compositeListener.addListener(new AnnotationValidatorServletContextListener());
        compositeListener.addListener(new DevModeServletContextListener());
        if (!WebComponentConfigurationRegistry.getInstance((VaadinContext)context).hasConfigurations()) {
            compositeListener.addListener(new WebComponentServletContextListener());
        }
        return compositeListener;
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotation(packages, this.customLoader, annotations);
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, ResourceLoader loader, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotationOrSuperType(packages, loader, Arrays.asList(annotations), Collections.emptySet());
    }

    Stream<Class<?>> findBySuperType(Collection<String> packages, Class<?> type) {
        return this.findBySuperType(packages, this.customLoader, type);
    }

    private Stream<Class<?>> findBySuperType(Collection<String> packages, ResourceLoader loader, Class<?> type) {
        return this.findByAnnotationOrSuperType(packages, loader, Collections.emptySet(), Collections.singleton(type));
    }

    Stream<Class<?>> findByAnnotationOrSuperType(Collection<String> packages, ResourceLoader loader, Collection<Class<? extends Annotation>> annotations, Collection<Class<?>> types) {
        ClassPathScanner scanner = new ClassPathScanner(this.appContext.getEnvironment(), loader, annotations, types);
        return packages.stream().map(arg_0 -> ((ClassPathScanner)scanner).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(this::getBeanClass);
    }

    private Class<?> getBeanClass(BeanDefinition beanDefinition) {
        Class beanClass;
        AbstractBeanDefinition definition = (AbstractBeanDefinition)beanDefinition;
        if (definition.hasBeanClass()) {
            beanClass = definition.getBeanClass();
        } else {
            try {
                beanClass = definition.resolveBeanClass(this.appContext.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return beanClass;
    }

    private Collection<String> getRoutePackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getVerifiableAnnotationPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getWebComponentPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getErrorParameterPackages() {
        return Stream.concat(Stream.of(HasErrorParameter.class.getPackage().getName()), this.getDefaultPackages().stream()).collect(Collectors.toSet());
    }

    List<String> getDefaultPackages() {
        List packagesList = Collections.emptyList();
        if (this.appContext.getBeanNamesForType(VaadinScanPackagesRegistrar.VaadinScanPackages.class).length > 0) {
            VaadinScanPackagesRegistrar.VaadinScanPackages packages = (VaadinScanPackagesRegistrar.VaadinScanPackages)this.appContext.getBean(VaadinScanPackagesRegistrar.VaadinScanPackages.class);
            packagesList = packages.getScanPackages();
        }
        if (!packagesList.isEmpty()) {
            VaadinServletContextInitializer.getLogger().trace("Using explicitly configured packages for scan Vaadin types at startup {}", packagesList);
        } else if (AutoConfigurationPackages.has((BeanFactory)this.appContext)) {
            packagesList = AutoConfigurationPackages.get((BeanFactory)this.appContext);
        }
        return packagesList;
    }

    private List<String> getLookupPackages() {
        return Stream.concat(this.getDefaultPackages().stream(), Stream.of("com.vaadin.hilla.frontend", "com.vaadin.flow.component.polymertemplate.rpc", "com.vaadin.base.devserver")).collect(Collectors.toList());
    }

    private static void collectHandleTypes(Class<?> clazz, List<Class<? extends Annotation>> annotations, List<Class<?>> superTypes) {
        HandlesTypes handlesTypes = clazz.getAnnotation(HandlesTypes.class);
        assert (handlesTypes != null);
        VaadinServletContextInitializer.collectHandleTypes(handlesTypes.value(), annotations, superTypes);
    }

    private static void collectHandleTypes(Class<?>[] handleTypes, List<Class<? extends Annotation>> annotations, List<Class<?>> superTypes) {
        assert (handleTypes != null);
        for (Class<?> type : handleTypes) {
            if (type.isAnnotation()) {
                annotations.add(type);
                continue;
            }
            superTypes.add(type);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinServletContextInitializer.class);
    }

    static {
        DEFAULT_SCAN_NEVER = Stream.of("antlr", "cglib", "ch/quos/logback", "commons-codec", "commons-fileupload", "commons-io", "commons-logging", "com/fasterxml", "com/google", "com/h2database", "com/helger", "com/vaadin/external/atmosphere", "com/vaadin/webjar", "junit", "net/bytebuddy", "org/apache", "org/aspectj", "org/bouncycastle", "org/dom4j", "org/easymock", "org/eclipse/persistence", "org/hamcrest", "org/hibernate", "org/javassist", "org/jboss", "org/jsoup", "org/seleniumhq", "org/slf4j", "org/atmosphere", "org/springframework", "org/webjars/bowergithub", "org/yaml", "java/", "javax/", "javafx/", "com/sun/", "oracle/deploy", "oracle/javafx", "oracle/jrockit", "oracle/jvm", "oracle/net", "oracle/nio", "oracle/tools", "oracle/util", "oracle/webservices", "oracle/xmlns", "com/intellij/", "org/jetbrains", "com/vaadin/external/gwt", "javassist/", "io/methvin", "com/github/javaparser", "oshi/", "io/micrometer", "jakarta/", "com/nimbusds", "elemental/util", "elemental/json", "org/reflections", "org/aopalliance", "org/objectweb", "com/vaadin/hilla", "com/vaadin/copilot").collect(Collectors.toList());
        DEFAULT_SCAN_ONLY = Stream.of(Component.class.getPackage().getName(), Theme.class.getPackage().getName(), "com.vaadin.flow.data.renderer", "com.vaadin.shrinkwrap", "com.vaadin.copilot.startup", "com.vaadin.hilla.startup").collect(Collectors.toList());
    }

    private static class CustomResourceLoader
    extends FilterableResourceResolver {
        private final PrefixTree scanNever = new PrefixTree(DEFAULT_SCAN_NEVER);
        private final PrefixTree scanAlways = new PrefixTree(DEFAULT_SCAN_ONLY.stream().map(packageName -> packageName.replace('.', '/')).collect(Collectors.toList()));
        private boolean filterOnlyByPackageProperties = false;
        private final ReentrantLock lock = new ReentrantLock(true);
        private Map<String, Resource[]> cache = new HashMap<String, Resource[]>();
        private Set<String> rootPaths = new HashSet<String>();

        public CustomResourceLoader(ResourceLoader resourceLoader, List<String> addedScanNever) {
            super(resourceLoader);
            Objects.requireNonNull(addedScanNever, "addedScanNever shouldn't be null!");
            addedScanNever.forEach(this.scanNever::addPrefix);
        }

        public CustomResourceLoader(ResourceLoader resourceLoader) {
            super(resourceLoader);
            this.filterOnlyByPackageProperties = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource[] getResources(String locationPattern) throws IOException {
            this.lock.lock();
            try {
                if (this.cache.containsKey(locationPattern)) {
                    Resource[] resourceArray = this.cache.get(locationPattern);
                    return resourceArray;
                }
                Resource[] resources = this.collectResources(locationPattern);
                this.cache.put(locationPattern, resources);
                Resource[] resourceArray = resources;
                return resourceArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Resource[] collectResources(String locationPattern) throws IOException {
            ArrayList<Resource> resourcesList = new ArrayList<Resource>();
            Set<String> skipped = ReloadCache.skippedResources;
            Set<String> valid = ReloadCache.validResources;
            for (Resource resource : super.getResources(locationPattern)) {
                String originalPath = resource.getURL().getPath();
                String path = originalPath.startsWith("file:///resources!") ? originalPath.substring("file:///resources!".length()) : originalPath;
                if (this.isDevModeCacheUsed() && skipped.contains(originalPath)) continue;
                if (this.isDevModeCacheUsed() && valid.contains(originalPath)) {
                    resourcesList.add(resource);
                    if (originalPath.endsWith("/")) {
                        this.rootPaths.add(originalPath);
                    }
                } else if (path.endsWith(".jar!/")) {
                    resourcesList.add(resource);
                } else if (path.endsWith("/")) {
                    this.rootPaths.add(path);
                    resourcesList.add(resource);
                } else {
                    int index = path.lastIndexOf(".jar!/");
                    if (index >= 0) {
                        String relativePath = path.substring(index + 6);
                        if (this.isDevModeCacheUsed() && relativePath.endsWith(".class")) {
                            String className = relativePath.replace(File.separatorChar, '.').replace(".class", "");
                            ReloadCache.jarClassNames.add(className);
                        }
                        if (this.shouldPathBeScanned(relativePath, path.substring(0, index))) {
                            resourcesList.add(resource);
                        }
                    } else {
                        List<String> parents = this.rootPaths.stream().filter(path::startsWith).toList();
                        if (parents.isEmpty()) {
                            throw new IllegalStateException(String.format("Parent resource of [%s] not found in the resources!", path));
                        }
                        AtomicBoolean parentIsAllowedByPackageProperties = new AtomicBoolean(true);
                        if (parents.stream().anyMatch(parent -> this.shouldPathBeScanned(path.substring(parent.length()), (String)parent, parentIsAllowedByPackageProperties))) {
                            resourcesList.add(resource);
                        }
                    }
                }
                if (!this.isDevModeCacheUsed()) continue;
                if (resourcesList.contains(resource)) {
                    valid.add(originalPath);
                    continue;
                }
                skipped.add(originalPath);
            }
            return resourcesList.toArray(new Resource[0]);
        }

        private boolean isDevModeCacheUsed() {
            return !this.filterOnlyByPackageProperties && devModeCachingEnabled;
        }

        private boolean shouldPathBeScanned(String path) {
            return this.filterOnlyByPackageProperties || this.scanAlways.hasPrefix(path) || !this.scanNever.hasPrefix(path);
        }

        private boolean shouldPathBeScanned(String path, String rootPath) {
            return this.shouldPathBeScanned(path, rootPath, null);
        }

        private boolean shouldPathBeScanned(String path, String rootPath, AtomicBoolean parentIsAllowedByPackageProperties) {
            if (this.shouldPathBeScanned(path)) {
                boolean defaultValue = parentIsAllowedByPackageProperties == null || parentIsAllowedByPackageProperties.get();
                boolean allowed = this.isAllowedByPackageProperties(rootPath, path, defaultValue);
                if (parentIsAllowedByPackageProperties != null) {
                    parentIsAllowedByPackageProperties.set(allowed);
                }
                return allowed;
            }
            return false;
        }
    }

    private static class CompositeServletContextListener
    implements ServletContextListener,
    Serializable {
        private final List<FailFastServletContextListener> listeners = new ArrayList<FailFastServletContextListener>();

        private CompositeServletContextListener() {
        }

        public void contextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            this.listeners.forEach(listener -> listener.contextInitialized(event));
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("Total time for Vaadin Servlet Context Init took {} ms", (Object)ms);
        }

        public void contextDestroyed(ServletContextEvent event) {
            this.listeners.forEach(listener -> listener.contextDestroyed(event));
        }

        private void addListener(FailFastServletContextListener listener) {
            this.listeners.add(listener);
        }
    }

    private class LookupInitializerListener
    extends LookupServletContainerInitializer
    implements FailFastServletContextListener {
        private LookupInitializerListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            long start = System.nanoTime();
            VaadinServletContext vaadinContext = new VaadinServletContext(event.getServletContext());
            if (vaadinContext.getAttribute(Lookup.class) != null) {
                return;
            }
            Set<Class<Object>> classes = null;
            if (devModeCachingEnabled) {
                classes = ReloadCache.lookupClasses;
            }
            if (classes == null) {
                classes = Stream.concat(VaadinServletContextInitializer.this.findByAnnotationOrSuperType(VaadinServletContextInitializer.this.getLookupPackages(), (ResourceLoader)VaadinServletContextInitializer.this.appContext, Collections.emptyList(), this.getServiceTypes()), Stream.of(LookupInitializer.class, SpringLookupInitializer.class)).collect(Collectors.toSet());
                if (devModeCachingEnabled) {
                    ReloadCache.lookupClasses = classes;
                }
            }
            this.process(classes, event.getServletContext());
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("Lookup initializer took {} ms", (Object)ms);
        }

        protected Collection<Class<?>> getServiceTypes() {
            List<Class<? extends Annotation>> annotations = Collections.emptyList();
            LinkedList types = new LinkedList();
            VaadinServletContextInitializer.collectHandleTypes(LookupServletContainerInitializer.class, annotations, types);
            types.remove(LookupInitializer.class);
            return types;
        }
    }

    private static interface FailFastServletContextListener
    extends ServletContextListener,
    Serializable {
        public static final String ATTR = "failed-" + FailFastServletContextListener.class.getName();

        default public void contextInitialized(ServletContextEvent event) {
            if (event.getServletContext().getAttribute(ATTR) == null) {
                try {
                    this.failFastContextInitialized(event);
                }
                catch (Exception e) {
                    event.getServletContext().setAttribute(ATTR, (Object)true);
                    throw new RuntimeException("Unable to initialize " + this.getClass().getName(), e);
                }
            }
        }

        default public void contextDestroyed(ServletContextEvent sce) {
        }

        public void failFastContextInitialized(ServletContextEvent var1) throws ServletException;
    }

    private class VaadinAppShellContextListener
    implements FailFastServletContextListener {
        private VaadinAppShellContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (config == null) {
                return;
            }
            if (!config.isProductionMode()) {
                VaadinServletContextInitializer.this.initializeDevModeClassCache();
            }
            Set classes = VaadinServletContextInitializer.this.findByAnnotationOrSuperType(VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), VaadinServletContextInitializer.this.customLoader, VaadinAppShellInitializer.getValidAnnotations(), VaadinAppShellInitializer.getValidSupers()).collect(Collectors.toSet());
            VaadinAppShellInitializer.init(classes, (VaadinContext)new VaadinServletContext(event.getServletContext()));
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("Search for VaadinAppShell took {} ms", (Object)ms);
        }
    }

    private class RouteServletContextListener
    extends AbstractRouteRegistryInitializer
    implements FailFastServletContextListener {
        private RouteServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            VaadinServletContext vaadinServletContext = new VaadinServletContext(event.getServletContext());
            ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)vaadinServletContext);
            VaadinServletContextInitializer.getLogger().debug("Servlet Context initialized. Running route discovering....");
            if (registry.getRegisteredRoutes().isEmpty()) {
                VaadinServletContextInitializer.getLogger().debug("There are no discovered routes yet. Start to collect all routes from the classpath...");
                try {
                    Collection<String> routePackages = devModeCachingEnabled && ReloadCache.routePackages != null ? ReloadCache.routePackages : VaadinServletContextInitializer.this.getRoutePackages();
                    List routeClasses = VaadinServletContextInitializer.this.findByAnnotation(routePackages, Route.class, RouteAlias.class).collect(Collectors.toList());
                    if (devModeCachingEnabled) {
                        ReloadCache.routePackages = routeClasses.stream().map(Class::getPackageName).collect(Collectors.toSet());
                    }
                    VaadinServletContextInitializer.getLogger().debug("Found {} route classes. Here is the list: {}", (Object)routeClasses.size(), routeClasses);
                    Set navigationTargets = this.validateRouteClasses((VaadinContext)vaadinServletContext, routeClasses.stream());
                    VaadinServletContextInitializer.getLogger().debug("There are {} navigation targets after filtering route classes: {}", (Object)navigationTargets.size(), (Object)navigationTargets);
                    Collection<String> layoutPackages = devModeCachingEnabled && ReloadCache.layoutPackages != null ? ReloadCache.layoutPackages : VaadinServletContextInitializer.this.getDefaultPackages();
                    Set layoutClasses = VaadinServletContextInitializer.this.findByAnnotation(layoutPackages, Layout.class).collect(Collectors.toSet());
                    if (devModeCachingEnabled) {
                        ReloadCache.layoutPackages = layoutClasses.stream().map(Class::getPackageName).collect(Collectors.toSet());
                    }
                    RouteRegistryInitializer.validateLayoutAnnotations(layoutClasses);
                    layoutClasses.stream().filter(clazz -> RouterLayout.class.isAssignableFrom((Class<?>)clazz)).forEach(clazz -> registry.setLayout(clazz));
                    RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
                    routeConfiguration.update((Command & Serializable)() -> this.setAnnotatedRoutes(routeConfiguration, navigationTargets));
                    registry.setPwaConfigurationClass(this.validatePwaClass((VaadinContext)vaadinServletContext, routeClasses.stream()));
                }
                catch (InvalidRouteConfigurationException | InvalidRouteLayoutConfigurationException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                VaadinServletContextInitializer.getLogger().debug("Skipped discovery as there was {} routes already in registry", (Object)registry.getRegisteredRoutes().size());
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("Route discovery took {} ms", (Object)ms);
        }

        private void setAnnotatedRoutes(RouteConfiguration routeConfiguration, Set<Class<? extends Component>> routes) {
            routeConfiguration.getHandledRegistry().clean();
            for (Class<? extends Component> navigationTarget : routes) {
                try {
                    routeConfiguration.setAnnotatedRoute(navigationTarget);
                }
                catch (AmbiguousRouteConfigurationException exception) {
                    if (this.handleAmbiguousRoute(routeConfiguration, exception.getConfiguredNavigationTarget(), navigationTarget)) continue;
                    throw exception;
                }
            }
        }

        private boolean handleAmbiguousRoute(RouteConfiguration routeConfiguration, Class<? extends Component> configuredNavigationTarget, Class<? extends Component> navigationTarget) {
            if (GenericTypeReflector.isSuperType(navigationTarget, configuredNavigationTarget)) {
                return true;
            }
            if (GenericTypeReflector.isSuperType(configuredNavigationTarget, navigationTarget)) {
                routeConfiguration.removeRoute(configuredNavigationTarget);
                routeConfiguration.setAnnotatedRoute(navigationTarget);
                return true;
            }
            return false;
        }
    }

    private class ErrorParameterServletContextListener
    implements FailFastServletContextListener {
        private ErrorParameterServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            Stream<Class> hasErrorComponents = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getErrorParameterPackages(), HasErrorParameter.class).filter(Component.class::isAssignableFrom).map(clazz -> clazz);
            registry.setErrorNavigationTargets(hasErrorComponents.collect(Collectors.toSet()));
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("Search for error navigation targets took {} ms", (Object)ms);
        }
    }

    private class AnnotationValidatorServletContextListener
    implements FailFastServletContextListener {
        private AnnotationValidatorServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            AnnotationValidator annotationValidator = new AnnotationValidator();
            this.validateAnnotations((ClassLoaderAwareServletContainerInitializer)annotationValidator, event.getServletContext(), annotationValidator.getAnnotations());
            WebComponentExporterAwareValidator extraValidator = new WebComponentExporterAwareValidator();
            this.validateAnnotations((ClassLoaderAwareServletContainerInitializer)extraValidator, event.getServletContext(), extraValidator.getAnnotations());
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("Annotation validation took {} ms", (Object)ms);
        }

        private void validateAnnotations(ClassLoaderAwareServletContainerInitializer initializer, ServletContext context, List<Class<?>> annotations) {
            Stream<Class<?>> annotatedClasses = VaadinServletContextInitializer.this.findByAnnotation(VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), annotations.toArray(new Class[annotations.size()]));
            Set set = annotatedClasses.collect(Collectors.toSet());
            try {
                initializer.process(set, context);
            }
            catch (ServletException exception) {
                throw new RuntimeException("Unexpected servlet exception from " + initializer.getClass() + " validator", exception);
            }
        }
    }

    private class DevModeServletContextListener
    implements FailFastServletContextListener {
        private transient DevModeHandlerManager devModeHandlerManager;

        private DevModeServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            VaadinServletContext vaadinContext = new VaadinServletContext(event.getServletContext());
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (config == null || config.isProductionMode()) {
                return;
            }
            Lookup lookup = (Lookup)vaadinContext.getAttribute(Lookup.class);
            this.devModeHandlerManager = (DevModeHandlerManager)lookup.lookup(DevModeHandlerManager.class);
            if (this.devModeHandlerManager == null) {
                throw new RuntimeException("no DevModeHandlerManager implementation found but but dev server enabled. Either disable by setting vaadin.frontend.hotdeploy=false (and run the build-frontend maven goal) or include the vaadin-dev-server dependency");
            }
            if (this.devModeHandlerManager.getDevModeHandler() != null) {
                return;
            }
            Set<String> basePackages = this.isScanOnlySet() ? new HashSet<String>(this.getScanOnlyPackages()) : (devModeCachingEnabled && ReloadCache.dynamicWhiteList != null ? ReloadCache.dynamicWhiteList : Collections.singleton(""));
            long start = System.nanoTime();
            ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
            ArrayList superTypes = new ArrayList();
            VaadinServletContextInitializer.collectHandleTypes(this.devModeHandlerManager.getHandlesTypes(), annotations, superTypes);
            Set<Class<?>> classes = VaadinServletContextInitializer.this.findClassesForDevMode(basePackages, annotations, superTypes);
            if (devModeCachingEnabled) {
                classes.addAll(ReloadCache.jarClasses);
                ReloadCache.dynamicWhiteList = classes.stream().filter(c -> !ReloadCache.jarClassNames.contains(c.getName())).map(Class::getPackageName).collect(Collectors.toSet());
                ReloadCache.jarClasses = classes.stream().filter(c -> ReloadCache.jarClassNames.contains(c.getName())).collect(Collectors.toSet());
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().info("Search for subclasses and classes with annotations took {} ms", (Object)ms);
            Environment environment = VaadinServletContextInitializer.this.appContext.getEnvironment();
            if (ms > 10000L && environment.getProperty("vaadin.allowed-packages") == null && environment.getProperty("vaadin.whitelisted-packages") == null) {
                VaadinServletContextInitializer.getLogger().info("Due to slow search it is recommended to use the allowed-packages feature to make scanning faster.\n\nSee the allowed-packages section in the docs at https://vaadin.com/docs/latest/flow/integrations/spring/configuration#special-configuration-parameters");
            }
            start = System.nanoTime();
            try {
                this.devModeHandlerManager.initDevModeHandler(classes, (VaadinContext)new VaadinServletContext(event.getServletContext()));
            }
            catch (VaadinInitializerException e) {
                throw new RuntimeException("Unable to initialize Vaadin DevModeHandler", e);
            }
            ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("DevModeHandlerManager init took {} ms", (Object)ms);
            event.getServletContext().setAttribute("livereload.port", (Object)environment.getProperty("spring.devtools.livereload.port"));
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            if (this.devModeHandlerManager != null) {
                this.devModeHandlerManager.stopDevModeHandler();
            }
        }

        private Collection<String> getScanOnlyPackages() {
            HashSet<String> npmPackages = new HashSet<String>(VaadinServletContextInitializer.this.getDefaultPackages());
            npmPackages.addAll(DEFAULT_SCAN_ONLY);
            if (VaadinServletContextInitializer.this.customScanOnly != null) {
                npmPackages.addAll(VaadinServletContextInitializer.this.customScanOnly);
            }
            return npmPackages;
        }

        private boolean isScanOnlySet() {
            return VaadinServletContextInitializer.this.customScanOnly != null && !VaadinServletContextInitializer.this.customScanOnly.isEmpty();
        }
    }

    private class WebComponentServletContextListener
    implements FailFastServletContextListener {
        private WebComponentServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            long start = System.nanoTime();
            WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (registry.getConfigurations() == null || registry.getConfigurations().isEmpty()) {
                WebComponentConfigurationRegistryInitializer initializer = new WebComponentConfigurationRegistryInitializer();
                Set webComponentExporters = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getWebComponentPackages(), WebComponentExporter.class).collect(Collectors.toSet());
                initializer.process(webComponentExporters, event.getServletContext());
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().debug("WebComponent init took {} ms", (Object)ms);
        }
    }

    private static class ClassPathScanner
    extends ClassPathScanningCandidateComponentProvider {
        private ClassPathScanner(Environment environment, ResourceLoader resourceLoader, Collection<Class<? extends Annotation>> annotations, Collection<Class<?>> types) {
            super(false, environment);
            this.setResourceLoader(resourceLoader);
            annotations.stream().map(AnnotationTypeFilter::new).forEach(arg_0 -> ((ClassPathScanner)this).addIncludeFilter(arg_0));
            types.stream().map(AssignableTypeFilter::new).forEach(arg_0 -> ((ClassPathScanner)this).addIncludeFilter(arg_0));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return super.isCandidateComponent(beanDefinition) || beanDefinition.getMetadata().isAbstract();
        }
    }
}

